/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.pathmapper;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.php.internal.core.util.preferences.IXMLPreferencesStorable;
import org.eclipse.php.internal.core.util.preferences.XMLPreferencesReader;
import org.eclipse.php.internal.core.util.preferences.XMLPreferencesWriter;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.launching.PHPLaunchUtilities;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapper;
import org.eclipse.php.internal.debug.core.preferences.IPHPExesListener;
import org.eclipse.php.internal.debug.core.preferences.PHPExesEvent;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.core.manager.IServersManagerListener;
import org.eclipse.php.internal.server.core.manager.ServerManagerEvent;
import org.eclipse.php.internal.server.core.manager.ServersManager;

public class PathMapperRegistry
implements IXMLPreferencesStorable {
    private static final String PATH_MAPPER_PREF_KEY = PHPDebugPlugin.getID() + ".pathMapper";
    private static PathMapperRegistry instance;
    private final Map<Server, PathMapper> serverPathMapper;
    private final Map<PHPexeItem, PathMapper> phpExePathMapper;
    private final Map<ILaunchConfiguration, PathMapper> launchConfigPathMapper = new WeakHashMap<ILaunchConfiguration, PathMapper>();
    private final MapperOwnerListener ownerListener;

    private PathMapperRegistry() {
        this.serverPathMapper = new HashMap<Server, PathMapper>();
        this.phpExePathMapper = new HashMap<PHPexeItem, PathMapper>();
        this.ownerListener = new MapperOwnerListener();
        List elements = XMLPreferencesReader.read((IEclipsePreferences)InstanceScope.INSTANCE.getNode("org.eclipse.php.debug.core"), (String)PATH_MAPPER_PREF_KEY, (boolean)true);
        if (elements.size() == 1) {
            this.restoreFromMap((Map)elements.get(0));
        }
    }

    public static synchronized PathMapperRegistry getInstance() {
        if (instance == null) {
            instance = new PathMapperRegistry();
        }
        return instance;
    }

    public static PathMapper getByPHPExe(PHPexeItem phpExe) {
        PathMapper result = PathMapperRegistry.getInstance().phpExePathMapper.get(phpExe);
        if (result == null) {
            result = new PathMapper();
            PathMapperRegistry.getInstance().phpExePathMapper.put(phpExe, result);
            PHPexes.getInstance().addPHPExesListener(PathMapperRegistry.getInstance().ownerListener);
        }
        return result;
    }

    public static PathMapper getByServer(Server server) {
        PathMapper result = PathMapperRegistry.getInstance().serverPathMapper.get(server);
        if (result == null) {
            result = new PathMapper();
            PathMapperRegistry.getInstance().serverPathMapper.put(server, result);
            ServersManager.addManagerListener((IServersManagerListener)PathMapperRegistry.getInstance().ownerListener);
        }
        return result;
    }

    public static PathMapper getByLaunchConfiguration(ILaunchConfiguration launchConfiguration) {
        PathMapper pathMapper = null;
        try {
            String serverName = launchConfiguration.getAttribute("name", null);
            if (serverName != null) {
                pathMapper = PathMapperRegistry.getByServer(ServersManager.getServer((String)serverName));
            } else if (PHPLaunchUtilities.isLaunchConfigurationTypeOf(launchConfiguration, "org.eclipse.php.debug.core.remotePHPLaunchConfigurationType") && (pathMapper = PathMapperRegistry.getInstance().launchConfigPathMapper.get(launchConfiguration)) == null) {
                pathMapper = new PathMapper();
                PathMapperRegistry.getInstance().launchConfigPathMapper.put(launchConfiguration, pathMapper);
            }
        }
        catch (CoreException e) {
            PHPDebugPlugin.log(e);
        }
        return pathMapper;
    }

    public static void storeToPreferences() {
        XMLPreferencesWriter.write((IEclipsePreferences)InstanceScope.INSTANCE.getNode("org.eclipse.php.debug.core"), (String)PATH_MAPPER_PREF_KEY, (IXMLPreferencesStorable)PathMapperRegistry.getInstance());
    }

    public synchronized void restoreFromMap(Map<String, Object> map) {
        if (map == null) {
            return;
        }
        this.serverPathMapper.clear();
        this.phpExePathMapper.clear();
        map = (Map)map.get("pathMappers");
        if (map == null) {
            return;
        }
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            PHPexeItem phpExeItem;
            Map entryMap = (Map)map.get(i.next());
            String serverName = (String)entryMap.get("server");
            String phpExeFile = (String)entryMap.get("phpExe");
            String phpIniFile = (String)entryMap.get("phpIni");
            PathMapper pathMapper = new PathMapper();
            pathMapper.restoreFromMap((Map)entryMap.get("mapper"));
            if (serverName != null) {
                Server server = ServersManager.getServer((String)serverName);
                if (server == null) continue;
                this.serverPathMapper.put(server, pathMapper);
                continue;
            }
            if (phpExeFile == null || (phpExeItem = PHPexes.getInstance().getItemForFile(phpExeFile, phpIniFile)) == null) continue;
            this.phpExePathMapper.put(phpExeItem, pathMapper);
        }
    }

    public synchronized Map<String, Object> storeToMap() {
        PathMapper pathMapper;
        HashMap<String, Object> entry;
        HashMap elements = new HashMap();
        Iterator<Object> i = this.serverPathMapper.keySet().iterator();
        int c = 1;
        while (i.hasNext()) {
            entry = new HashMap<String, Object>();
            Server server = (Server)i.next();
            pathMapper = this.serverPathMapper.get(server);
            entry.put("server", server.getName());
            if (pathMapper != null) {
                entry.put("mapper", pathMapper.storeToMap());
            }
            elements.put((CallSite)((Object)("item" + c++)), entry);
        }
        i = this.phpExePathMapper.keySet().iterator();
        while (i.hasNext()) {
            entry = new HashMap();
            PHPexeItem phpExeItem = (PHPexeItem)i.next();
            pathMapper = this.phpExePathMapper.get(phpExeItem);
            entry.put("phpExe", phpExeItem.getExecutable().toString());
            if (phpExeItem.getINILocation() != null) {
                entry.put("phpIni", phpExeItem.getINILocation().toString());
            }
            entry.put("mapper", pathMapper.storeToMap());
            elements.put((CallSite)((Object)("item" + c++)), entry);
        }
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("pathMappers", elements);
        return root;
    }

    private class MapperOwnerListener
    implements IServersManagerListener,
    IPHPExesListener {
        private MapperOwnerListener() {
        }

        public void serverAdded(ServerManagerEvent event) {
            if (!PathMapperRegistry.this.serverPathMapper.containsKey(event.getServer())) {
                PathMapperRegistry.this.serverPathMapper.put(event.getServer(), new PathMapper());
            }
        }

        public void serverModified(ServerManagerEvent event) {
        }

        public void serverRemoved(ServerManagerEvent event) {
            PathMapperRegistry.this.serverPathMapper.remove(event.getServer());
        }

        @Override
        public void phpExeAdded(PHPExesEvent event) {
            if (!PathMapperRegistry.this.phpExePathMapper.containsKey(event.getPHPExeItem())) {
                PathMapperRegistry.this.phpExePathMapper.put(event.getPHPExeItem(), new PathMapper());
            }
        }

        @Override
        public void phpExeRemoved(PHPExesEvent event) {
            PathMapperRegistry.this.phpExePathMapper.remove(event.getPHPExeItem());
        }
    }
}

