/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.classloaderhandler;

import java.io.IOError;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import nonapi.io.github.classgraph.classloaderhandler.ClassLoaderHandler;
import nonapi.io.github.classgraph.classpath.ClassLoaderFinder;
import nonapi.io.github.classgraph.classpath.ClassLoaderOrder;
import nonapi.io.github.classgraph.classpath.ClasspathOrder;
import nonapi.io.github.classgraph.scanspec.ScanSpec;
import nonapi.io.github.classgraph.utils.LogNode;

class QuarkusClassLoaderHandler
implements ClassLoaderHandler {
    private static final String RUNTIME_CLASSLOADER = "io.quarkus.runner.RuntimeClassLoader";
    private static final String QUARKUS_CLASSLOADER = "io.quarkus.bootstrap.classloading.QuarkusClassLoader";
    private static final String RUNNER_CLASSLOADER = "io.quarkus.bootstrap.runner.RunnerClassLoader";
    private static final Map<String, String> PRE_311_RESOURCE_BASED_ELEMENTS;

    static {
        HashMap<String, String> hlp = new HashMap<String, String>();
        hlp.put("io.quarkus.bootstrap.classloading.JarClassPathElement", "file");
        hlp.put("io.quarkus.bootstrap.classloading.DirectoryClassPathElement", "root");
        PRE_311_RESOURCE_BASED_ELEMENTS = Collections.unmodifiableMap(hlp);
    }

    private QuarkusClassLoaderHandler() {
    }

    public static boolean canHandle(Class<?> classLoaderClass, LogNode log) {
        return ClassLoaderFinder.classIsOrExtendsOrImplements(classLoaderClass, RUNTIME_CLASSLOADER) || ClassLoaderFinder.classIsOrExtendsOrImplements(classLoaderClass, QUARKUS_CLASSLOADER) || ClassLoaderFinder.classIsOrExtendsOrImplements(classLoaderClass, RUNNER_CLASSLOADER);
    }

    public static void findClassLoaderOrder(ClassLoader classLoader, ClassLoaderOrder classLoaderOrder, LogNode log) {
        classLoaderOrder.delegateTo(classLoader.getParent(), true, log);
        classLoaderOrder.add(classLoader, log);
    }

    public static void findClasspathOrder(ClassLoader classLoader, ClasspathOrder classpathOrder, ScanSpec scanSpec, LogNode log) {
        String classLoaderName = classLoader.getClass().getName();
        if (RUNTIME_CLASSLOADER.equals(classLoaderName)) {
            QuarkusClassLoaderHandler.findClasspathOrderForRuntimeClassloader(classLoader, classpathOrder, scanSpec, log);
        } else if (QUARKUS_CLASSLOADER.equals(classLoaderName)) {
            QuarkusClassLoaderHandler.findClasspathOrderForQuarkusClassloader(classLoader, classpathOrder, scanSpec, log);
        } else if (RUNNER_CLASSLOADER.equals(classLoaderName)) {
            QuarkusClassLoaderHandler.findClasspathOrderForRunnerClassloader(classLoader, classpathOrder, scanSpec, log);
        }
    }

    private static void findClasspathOrderForQuarkusClassloader(ClassLoader classLoader, ClasspathOrder classpathOrder, ScanSpec scanSpec, LogNode log) {
        Collection<Object> elements = QuarkusClassLoaderHandler.findQuarkusClassLoaderElements(classLoader, classpathOrder);
        for (Object element : elements) {
            String elementClassName = element.getClass().getName();
            String fieldName = PRE_311_RESOURCE_BASED_ELEMENTS.get(elementClassName);
            if (fieldName != null) {
                classpathOrder.addClasspathEntry(classpathOrder.reflectionUtils.getFieldVal(false, element, fieldName), classLoader, scanSpec, log);
                continue;
            }
            Object rootPath = classpathOrder.reflectionUtils.invokeMethod(false, element, "getRoot");
            if (!(rootPath instanceof Path)) continue;
            classpathOrder.addClasspathEntry(rootPath, classLoader, scanSpec, log);
        }
    }

    private static Collection<Object> findQuarkusClassLoaderElements(ClassLoader classLoader, ClasspathOrder classpathOrder) {
        ArrayList elements = (ArrayList)classpathOrder.reflectionUtils.getFieldVal(false, (Object)classLoader, "elements");
        if (elements == null) {
            elements = new ArrayList();
            String[] stringArray = new String[]{"normalPriorityElements", "lesserPriorityElements"};
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String fieldName = stringArray[n2];
                Collection fieldVal = (Collection)classpathOrder.reflectionUtils.getFieldVal(false, (Object)classLoader, fieldName);
                if (fieldVal != null) {
                    elements.addAll(fieldVal);
                }
                ++n2;
            }
        }
        return elements;
    }

    private static void findClasspathOrderForRuntimeClassloader(ClassLoader classLoader, ClasspathOrder classpathOrder, ScanSpec scanSpec, LogNode log) {
        Collection applicationClassDirectories = (Collection)classpathOrder.reflectionUtils.getFieldVal(false, (Object)classLoader, "applicationClassDirectories");
        if (applicationClassDirectories != null) {
            for (Path path : applicationClassDirectories) {
                try {
                    URI uri = path.toUri();
                    classpathOrder.addClasspathEntryObject(uri, classLoader, scanSpec, log);
                }
                catch (IOError | SecurityException e) {
                    if (log == null) continue;
                    log.log("Could not convert path to URI: " + path);
                }
            }
        }
    }

    private static void findClasspathOrderForRunnerClassloader(ClassLoader classLoader, ClasspathOrder classpathOrder, ScanSpec scanSpec, LogNode log) {
        Iterator iterator = ((Map)classpathOrder.reflectionUtils.getFieldVal(false, (Object)classLoader, "resourceDirectoryMap")).values().iterator();
        while (iterator.hasNext()) {
            Object[] elementArray;
            Object[] objectArray = elementArray = (Object[])iterator.next();
            int n = elementArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                String elementClassName = element.getClass().getName();
                if ("io.quarkus.bootstrap.runner.JarResource".equals(elementClassName)) {
                    classpathOrder.addClasspathEntry(classpathOrder.reflectionUtils.getFieldVal(false, element, "jarPath"), classLoader, scanSpec, log);
                }
                ++n2;
            }
        }
    }
}

