/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.compiler.ast.nodes;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.php.core.compiler.ast.nodes.Comment;
import org.eclipse.php.core.compiler.ast.nodes.PHPDocTag;
import org.eclipse.php.core.compiler.ast.nodes.Scalar;

public class PHPDocBlock
extends Comment {
    private String shortDescription;
    private String longDescription;
    private PHPDocTag[] tags;
    private List<Scalar> texts;

    public PHPDocBlock(int start, int end, String shortDescription, String longDescription, PHPDocTag[] tags) {
        this(start, end, shortDescription, longDescription, tags, null);
    }

    public PHPDocBlock(int start, int end, String shortDescription, String longDescription, PHPDocTag[] tags, List<Scalar> texts) {
        super(start, end, 2);
        this.shortDescription = shortDescription;
        this.longDescription = longDescription;
        this.tags = tags;
        this.texts = texts;
    }

    @Override
    public void traverse(ASTVisitor visitor) throws Exception {
        boolean visit = visitor.visit((ASTNode)this);
        if (visit) {
            PHPDocTag[] pHPDocTagArray = this.tags;
            int n = this.tags.length;
            int n2 = 0;
            while (n2 < n) {
                PHPDocTag tag = pHPDocTagArray[n2];
                tag.traverse(visitor);
                ++n2;
            }
        }
        visitor.endvisit((ASTNode)this);
    }

    public int getKind() {
        return 67;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public String getLongDescription() {
        return this.longDescription;
    }

    public PHPDocTag[] getTags() {
        return this.tags;
    }

    public List<Scalar> getTexts() {
        return this.texts;
    }

    public PHPDocTag[] getTags(PHPDocTag.TagKind kind) {
        LinkedList<PHPDocTag> res = new LinkedList<PHPDocTag>();
        if (this.tags != null) {
            PHPDocTag[] pHPDocTagArray = this.tags;
            int n = this.tags.length;
            int n2 = 0;
            while (n2 < n) {
                PHPDocTag tag = pHPDocTagArray[n2];
                if (tag.getTagKind() == kind) {
                    res.add(tag);
                }
                ++n2;
            }
        }
        return res.toArray(new PHPDocTag[res.size()]);
    }

    public void adjustStart(int start) {
        this.setStart(this.sourceStart() + start);
        this.setEnd(this.sourceEnd() + start);
        PHPDocTag[] pHPDocTagArray = this.tags;
        int n = this.tags.length;
        int n2 = 0;
        while (n2 < n) {
            PHPDocTag tag = pHPDocTagArray[n2];
            tag.adjustStart(start);
            ++n2;
        }
    }
}

