/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.Disk;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.IoOperationType;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.segment.interfaces.INamedSegment;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;

public class RequestIntervalSegment
implements INamedSegment {
    private static final long serialVersionUID = 3064409294604514508L;
    private final ITmfStateInterval fInterval;
    private final IoOperationType fType;
    private final String fDiskName;

    public static @Nullable RequestIntervalSegment create(ITmfStateInterval interval, @Nullable Disk disk) {
        Object value = interval.getValue();
        if (value instanceof Integer) {
            return new RequestIntervalSegment(interval, IoOperationType.fromNumber((Integer)value), disk);
        }
        return null;
    }

    private RequestIntervalSegment(ITmfStateInterval interval, IoOperationType ioOperationType, @Nullable Disk disk) {
        this.fInterval = interval;
        this.fType = ioOperationType;
        this.fDiskName = disk != null ? disk.getDiskName() : "";
    }

    public int compareTo(@NonNull ISegment o) {
        return 0;
    }

    public long getStart() {
        return this.fInterval.getStartTime();
    }

    public long getEnd() {
        return this.fInterval.getEndTime() + 1L;
    }

    public String getName() {
        return this.fDiskName.isEmpty() ? String.valueOf((Object)this.fType) : String.valueOf(this.fDiskName) + ' ' + ':' + ' ' + String.valueOf((Object)this.fType);
    }

    public IoOperationType getOperationType() {
        return this.fType;
    }

    public @Nullable String getDiskName() {
        return this.fDiskName;
    }
}

