/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.views.coverage;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.php.internal.debug.ui.views.coverage.CodeCoverageContentProvider;
import org.eclipse.php.internal.debug.ui.views.coverage.CodeCoverageResult;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class CodeCoverageLabelProvider
extends AppearanceAwareLabelProvider
implements ITableLabelProvider,
ITableColorProvider,
ITableFontProvider {
    private CodeCoverageContentProvider cProvider;

    public CodeCoverageLabelProvider(CodeCoverageContentProvider cProvider) {
        super(PHPUiPlugin.getDefault().getPreferenceStore());
        this.cProvider = cProvider;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                if (element instanceof String) {
                    return PHPUiPlugin.getImageDescriptorRegistry().get(PHPPluginImages.DESC_OBJS_CUNIT);
                }
                return super.getImage(element);
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        CodeCoverageResult coverageResult = this.cProvider.getCodeCoverageResult(element);
        switch (columnIndex) {
            case 0: {
                if (element instanceof String) {
                    return (String)element;
                }
                StringBuilder text = new StringBuilder(super.getText(element));
                if (coverageResult.getFiles() > 1 || this.cProvider.hasChildren(element)) {
                    text.append(MessageFormat.format(" ({0})", String.valueOf(coverageResult.getFiles())));
                }
                return text.toString();
            }
            case 1: {
                float percentage = coverageResult.getPercentage();
                if (Float.isNaN(percentage)) {
                    return null;
                }
                return MessageFormat.format("{0,number,percent} ({1}/{2}/{3})", new Float(coverageResult.getPercentage()), String.valueOf(coverageResult.getCovered()), String.valueOf(coverageResult.getSignificant()), String.valueOf(coverageResult.getLines()));
            }
        }
        return null;
    }

    public Color getBackground(Object element, int columnIndex) {
        return null;
    }

    public Color getForeground(Object element, int columnIndex) {
        if (columnIndex == 1 && (element instanceof ISourceModule || element instanceof IFile)) {
            return JFaceColors.getHyperlinkText((Display)Display.getCurrent());
        }
        return null;
    }

    public Font getFont(Object element, int columnIndex) {
        if (columnIndex == 1 && (element instanceof ISourceModule || element instanceof IFile)) {
            return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
        }
        return JFaceResources.getFontRegistry().get("org.eclipse.jface.defaultfont");
    }
}

