/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.core.sourcelookup.containers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.containers.ContainerSourceContainer;

public class ProjectSourceContainer
extends ContainerSourceContainer {
    boolean fReferencedProjects = false;
    public static final String TYPE_ID = String.valueOf(DebugPlugin.getUniqueIdentifier()) + ".containerType.project";

    public ProjectSourceContainer(IProject project, boolean referenced) {
        super((IContainer)project, true);
        this.fReferencedProjects = referenced;
    }

    public boolean isSearchReferencedProjects() {
        return this.fReferencedProjects;
    }

    public IProject getProject() {
        return (IProject)this.getContainer();
    }

    @Override
    public ISourceContainerType getType() {
        return this.getSourceContainerType(TYPE_ID);
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    @Override
    protected ISourceContainer[] createSourceContainers() throws CoreException {
        if (this.getProject().isOpen()) {
            if (this.isSearchReferencedProjects()) {
                IProject project = this.getProject();
                IProject[] projects = this.getAllReferencedProjects(project);
                ISourceContainer[] folders = super.createSourceContainers();
                ArrayList<ProjectSourceContainer> all = new ArrayList<ProjectSourceContainer>(folders.length + projects.length);
                Collections.addAll(all, folders);
                IProject[] iProjectArray = projects;
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject p = iProjectArray[n2];
                    if (project.exists() && project.isOpen()) {
                        ProjectSourceContainer container = new ProjectSourceContainer(p, false);
                        container.init(this.getDirector());
                        all.add(container);
                    }
                    ++n2;
                }
                return all.toArray(new ISourceContainer[all.size()]);
            }
            return super.createSourceContainers();
        }
        return new ISourceContainer[0];
    }

    private IProject[] getAllReferencedProjects(IProject project) throws CoreException {
        HashSet<IProject> all = new HashSet<IProject>();
        this.getAllReferencedProjects(all, project);
        return all.toArray(new IProject[all.size()]);
    }

    private void getAllReferencedProjects(Set<IProject> all, IProject project) throws CoreException {
        IProject[] refs;
        IProject[] iProjectArray = refs = project.getReferencedProjects();
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            IProject ref = iProjectArray[n2];
            if (!all.contains(ref) && ref.exists() && ref.isOpen()) {
                all.add(ref);
                this.getAllReferencedProjects(all, ref);
            }
            ++n2;
        }
    }
}

