/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.generation.statement;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.association.Association;
import org.eclipse.wb.core.model.association.AssociationUtils;
import org.eclipse.wb.internal.core.model.generation.statement.StatementGenerator;
import org.eclipse.wb.internal.core.model.variable.VariableSupport;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.StatementTarget;

public abstract class AbstractInsideStatementGenerator
extends StatementGenerator {
    protected static void add(JavaInfo child, StatementTarget target, String[] leadingComments, Association association) throws Exception {
        AstEditor editor = child.getEditor();
        VariableSupport variableSupport = child.getVariableSupport();
        String statementSource = variableSupport.add_getVariableStatementSource(target);
        if (statementSource != null) {
            statementSource = AssociationUtils.replaceTemplates(child, statementSource, target);
            ArrayList lines = Lists.newArrayList();
            if (leadingComments != null) {
                Collections.addAll(lines, leadingComments);
            }
            Collections.addAll(lines, StringUtils.split((String)statementSource, (char)'\n'));
            leadingComments = null;
            Statement variableStatement = editor.addStatement(lines, target);
            variableSupport.add_setVariableStatement(variableStatement);
            AbstractInsideStatementGenerator.addRelatedNodes(child, (ASTNode)variableStatement);
            target = variableSupport.getAssociationTarget(target);
        }
        association.add(child, target, leadingComments);
    }

    public static void addRelatedNodes(JavaInfo child, ASTNode statement) {
        child.addRelatedNodes(statement);
        child.getParentJava().addRelatedNodes(statement);
    }
}

