/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.datastore.core.condition;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.datastore.core.condition.TimeRangeCondition;

public class ContinuousTimeRangeCondition
implements TimeRangeCondition {
    private final long fLongMin;
    private final long fLongMax;

    public ContinuousTimeRangeCondition(long low, long high) {
        if (high < low) {
            throw new IllegalArgumentException("Continuous time range condition: lower bound (" + low + ") should be <= upper bound (" + high + ')');
        }
        this.fLongMin = low;
        this.fLongMax = high;
    }

    @Override
    public long min() {
        return this.fLongMin;
    }

    @Override
    public long max() {
        return this.fLongMax;
    }

    @Override
    public boolean test(long element) {
        return element >= this.fLongMin && element <= this.fLongMax;
    }

    @Override
    public boolean intersects(long low, long high) {
        return this.fLongMin <= high && this.fLongMax >= low;
    }

    @Override
    public @Nullable TimeRangeCondition subCondition(long from, long to) {
        long low = Math.max(from, this.fLongMin);
        long high = Math.min(this.fLongMax, to);
        if (high < low) {
            return null;
        }
        return new ContinuousTimeRangeCondition(low, high);
    }

    public String toString() {
        return "ContinuousTimeRangeCondition: (" + this.min() + '\u2025' + this.max() + ')';
    }
}

