/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.profile.core.data;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.php.profile.core.data.ProfilerFunctionData;

public class ProfilerClassData {
    private List<ProfilerFunctionData> fMethods = new ArrayList<ProfilerFunctionData>();
    private String fName;
    private double totalOwnTime = 0.0;

    public ProfilerClassData() {
    }

    public ProfilerClassData(String name) {
        this.fName = name;
    }

    public void setName(String name) {
        this.fName = name;
    }

    public String getName() {
        return this.fName;
    }

    public void addMethod(ProfilerFunctionData method) {
        this.fMethods.add(method);
        this.totalOwnTime += method.getOwnTime();
    }

    public ProfilerFunctionData[] getMethods() {
        ProfilerFunctionData[] mfd = new ProfilerFunctionData[this.fMethods.size()];
        this.fMethods.toArray(mfd);
        return mfd;
    }

    public double getTotalOwnTime() {
        return this.totalOwnTime;
    }

    public double getTotalOwnTimeInMilli() {
        return this.totalOwnTime * 1000.0;
    }

    public String toString() {
        return this.fName;
    }
}

