/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerConnectionInfo;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.docker.core.IDockerImageInfo;
import org.eclipse.linuxtools.internal.docker.ui.databinding.BaseDatabindingModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.DataVolumeModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.EnvironmentVariableModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.LabelVariableModel;

public class ImageRunResourceVolumesVariablesModel
extends BaseDatabindingModel {
    public static final long CPU_LOW = 512L;
    public static final long CPU_MEDIUM = 1024L;
    public static final long CPU_HIGH = 2048L;
    public static final int DEFAULT_MEMORY = 512;
    public static final String ENABLE_RESOURCE_LIMITATIONS = "enableResourceLimitations";
    public static final String CPU_SHARE_WEIGHT = "cpuShareWeight";
    public static final String MEMORY_LIMIT = "memoryLimit";
    public static final String DATA_VOLUMES = "dataVolumes";
    public static final String SELECTED_DATA_VOLUMES = "selectedDataVolumes";
    public static final String ENVIRONMENT_VARIABLES = "environmentVariables";
    public static final String LABEL_VARIABLES = "labelVariables";
    private boolean enableResourceLimitations = false;
    private final IDockerConnection connection;
    private IDockerConnectionInfo info;
    private IDockerImageInfo imageInfo = null;
    private long memoryLimit = 512L;
    private long cpuShareWeighting = 1024L;
    private Set<DataVolumeModel> selectedDataVolumes = new HashSet<DataVolumeModel>();
    private WritableList<DataVolumeModel> dataVolumes = new WritableList();
    private WritableList<EnvironmentVariableModel> environmentVariables = new WritableList();
    private WritableList<LabelVariableModel> labelVariables = new WritableList();
    private IDockerImage selectedImage;

    public ImageRunResourceVolumesVariablesModel(IDockerConnection connection) throws DockerException {
        this.connection = connection;
        if (this.connection != null) {
            this.info = connection.getInfo();
        }
    }

    public ImageRunResourceVolumesVariablesModel(IDockerImage selectedImage) throws DockerException {
        this(selectedImage.getConnection());
        this.selectedImage = selectedImage;
    }

    public IDockerConnection getConnection() {
        return this.connection;
    }

    public void setSelectedImage(IDockerImage selectedImage) {
        if (this.selectedImage == null || !this.selectedImage.equals(selectedImage)) {
            this.selectedImage = selectedImage;
            if (selectedImage != null) {
                this.imageInfo = selectedImage.getConnection().getImageInfo(selectedImage.id());
                if (this.imageInfo.config() != null && this.imageInfo.config().volumes() != null) {
                    ArrayList<DataVolumeModel> volumes = new ArrayList<DataVolumeModel>();
                    for (String volume : this.imageInfo.config().volumes().keySet()) {
                        volumes.add(new DataVolumeModel(volume));
                    }
                    this.setDataVolumes(volumes);
                }
            } else {
                this.setDataVolumes(Collections.emptyList());
            }
        }
    }

    public IDockerImage getSelectedImage() {
        return this.selectedImage;
    }

    public IDockerImageInfo getSelectedImageInfo() {
        return this.imageInfo;
    }

    public WritableList<DataVolumeModel> getDataVolumes() {
        return this.dataVolumes;
    }

    public void setDataVolumes(Collection<DataVolumeModel> volumes) {
        this.dataVolumes.clear();
        if (volumes != null) {
            this.dataVolumes.addAll(volumes);
        }
    }

    public void removeDataVolume(DataVolumeModel dataVolume) {
        this.dataVolumes.remove((Object)dataVolume);
    }

    public Set<DataVolumeModel> getSelectedDataVolumes() {
        return this.selectedDataVolumes;
    }

    public void setSelectedDataVolumes(Set<DataVolumeModel> selectedDataVolumes) {
        this.selectedDataVolumes = selectedDataVolumes;
        this.firePropertyChange(SELECTED_DATA_VOLUMES, this.selectedDataVolumes, this.selectedDataVolumes);
    }

    public WritableList<EnvironmentVariableModel> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public void setEnvironmentVariables(List<String> environmentVariables) {
        this.environmentVariables.clear();
        if (environmentVariables != null) {
            for (String envVariable : environmentVariables) {
                String[] items = envVariable.split("=");
                if (items.length != 2) continue;
                this.environmentVariables.add((Object)new EnvironmentVariableModel(items[0], items[1]));
            }
        }
    }

    public void setEnvironmentVariables(WritableList<EnvironmentVariableModel> environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.firePropertyChange(ENVIRONMENT_VARIABLES, this.environmentVariables, this.environmentVariables);
    }

    public void addEnvironmentVariable(EnvironmentVariableModel variable) {
        this.environmentVariables.add((Object)variable);
    }

    public void removeEnvironmentVariables() {
        this.environmentVariables.clear();
    }

    public void removeEnvironmentVariable(EnvironmentVariableModel variable) {
        this.environmentVariables.remove((Object)variable);
    }

    public WritableList<LabelVariableModel> getLabelVariables() {
        return this.labelVariables;
    }

    public void setLabelVariables(Map<String, String> labelVariables) {
        this.labelVariables.clear();
        if (labelVariables != null) {
            for (Map.Entry<String, String> entry : labelVariables.entrySet()) {
                this.labelVariables.add((Object)new LabelVariableModel(entry.getKey(), entry.getValue()));
            }
        }
    }

    public void setLabelVariables(WritableList<LabelVariableModel> labelVariables) {
        this.labelVariables = labelVariables;
        this.firePropertyChange(LABEL_VARIABLES, this.labelVariables, this.labelVariables);
    }

    public void addLabelVariable(LabelVariableModel variable) {
        this.labelVariables.add((Object)variable);
    }

    public void removeLabelVariables() {
        this.labelVariables.clear();
    }

    public void removeLabelVariable(LabelVariableModel variable) {
        this.labelVariables.remove((Object)variable);
    }

    public int getTotalMemory() {
        if (this.info != null) {
            return (int)(this.info.getTotalMemory() / 0x100000L);
        }
        return -1;
    }

    public boolean isEnableResourceLimitations() {
        return this.enableResourceLimitations;
    }

    public void setEnableResourceLimitations(boolean enableResourceLimitations) {
        this.enableResourceLimitations = enableResourceLimitations;
        this.firePropertyChange(ENABLE_RESOURCE_LIMITATIONS, this.enableResourceLimitations, this.enableResourceLimitations);
    }

    public long getMemoryLimit() {
        return this.memoryLimit;
    }

    public void setMemoryLimit(long memoryLimit) {
        this.memoryLimit = memoryLimit;
        this.firePropertyChange(MEMORY_LIMIT, this.memoryLimit, this.memoryLimit);
    }

    public long getCpuShareWeight() {
        return this.cpuShareWeighting;
    }

    public void setCpuShareWeight(long cpuShareWeighting) {
        if (cpuShareWeighting != 0L) {
            this.cpuShareWeighting = cpuShareWeighting;
            this.firePropertyChange(CPU_SHARE_WEIGHT, this.cpuShareWeighting, this.cpuShareWeighting);
        }
    }

    public static enum MountType {
        NONE,
        HOST_FILE_SYSTEM,
        CONTAINER;

    }
}

