/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.application;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.cdt.debug.application.ApplicationActionBarAdvisor;
import org.eclipse.cdt.debug.application.CoreFileDialog;
import org.eclipse.cdt.debug.application.CoreFileInfo;
import org.eclipse.cdt.debug.application.Messages;
import org.eclipse.cdt.debug.application.NewExecutableDialog;
import org.eclipse.cdt.debug.application.NewExecutableInfo;
import org.eclipse.cdt.debug.application.RemoteExecutableDialog;
import org.eclipse.cdt.debug.application.RemoteExecutableInfo;
import org.eclipse.cdt.internal.debug.application.DebugAttachedExecutable;
import org.eclipse.cdt.internal.debug.application.DebugCoreFile;
import org.eclipse.cdt.internal.debug.application.DebugExecutable;
import org.eclipse.cdt.internal.debug.application.DebugRemoteExecutable;
import org.eclipse.cdt.internal.debug.application.JobContainer;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;

public class ApplicationWorkbenchWindowAdvisor
extends WorkbenchWindowAdvisor {
    private static final String STANDALONE_QUALIFIER = "org.eclipse.cdt.debug.application";
    private static final String LAST_LAUNCH = "lastLaunch";
    private ILaunchConfiguration config;

    public ApplicationWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        super(configurer);
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        return new ApplicationActionBarAdvisor(configurer);
    }

    public void preWindowOpen() {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        configurer.setShowCoolBar(true);
        configurer.setShowStatusLine(true);
        configurer.setShowMenuBar(true);
        configurer.setShowProgressIndicator(true);
        configurer.setTitle(Messages.Debugger_Title);
    }

    public void postWindowCreate() {
        super.postWindowCreate();
        try {
            PostWindowCreateRunnable op = new PostWindowCreateRunnable();
            new ProgressMonitorDialog(this.getWindowConfigurer().getWindow().getShell()).run(true, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private String findExecutable(String input) {
        String result;
        block8: {
            result = input;
            Path x = new Path(input);
            try {
                if (x.isAbsolute() || x.segmentCount() != 1) break block8;
                String command = "which " + input;
                Process p = null;
                InputStream in = null;
                try {
                    p = ProcessFactory.getFactory().exec(command);
                    in = p.getInputStream();
                    InputStreamReader reader = new InputStreamReader(in);
                    BufferedReader br = new BufferedReader(reader);
                    String line = br.readLine();
                    if (line != null) {
                        result = line;
                    }
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                    if (p != null) {
                        p.destroy();
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    private void appendChar(StringBuilder builder, int repeat, char c) {
        int i = 0;
        while (i < repeat) {
            builder.append(c);
            ++i;
        }
    }

    private boolean needsEscaping(String input) {
        int i = 0;
        while (i < input.length()) {
            char c = input.charAt(i);
            if (c == ' ' || c == '\t' || c == '\n' || c == '\r' || c == '\"') {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String escapeArg(String arg) {
        if (!arg.isEmpty() && !this.needsEscaping(arg)) {
            return arg;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append('\"');
        int i = 0;
        while (i < arg.length()) {
            int numberOfBackslashes = 0;
            while (i < arg.length() && arg.charAt(i) == '\\') {
                ++i;
                ++numberOfBackslashes;
            }
            if (i == arg.length()) {
                this.appendChar(buffer, numberOfBackslashes * 2, '\\');
                break;
            }
            if (arg.charAt(i) == '\"') {
                this.appendChar(buffer, numberOfBackslashes * 2 + 1, '\\');
                buffer.append(arg.charAt(i));
            } else {
                this.appendChar(buffer, numberOfBackslashes * 2, '\\');
                buffer.append(arg.charAt(i));
            }
            ++i;
        }
        buffer.append('\"');
        return buffer.toString();
    }

    public void postWindowClose() {
        if (ResourcesPlugin.getWorkspace() != null) {
            this.disconnectFromWorkspace();
        }
        super.postWindowClose();
    }

    private void disconnectFromWorkspace() {
        MultiStatus status = new MultiStatus("GDBStandalone", 1, Messages.ProblemSavingWorkbench, null);
        try {
            ProgressMonitorDialog p = new ProgressMonitorDialog(null);
            IRunnableWithProgress runnable = monitor -> {
                try {
                    status.merge(ResourcesPlugin.getWorkspace().save(true, monitor));
                }
                catch (CoreException e) {
                    status.merge(e.getStatus());
                }
            };
            p.run(true, false, runnable);
        }
        catch (InvocationTargetException e) {
            status.merge((IStatus)new Status(4, "GDBStandalone", 1, Messages.InternalError, e.getTargetException()));
        }
        catch (InterruptedException e) {
            status.merge((IStatus)new Status(4, "GDBStandalone", 1, Messages.InternalError, (Throwable)e));
        }
        ErrorDialog.openError(null, (String)Messages.ProblemsSavingWorkspace, null, (IStatus)status, (int)6);
        if (!status.isOK()) {
            ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
        }
    }

    public class PostWindowCreateRunnable
    implements IRunnableWithProgress {
        /*
         * Loose catch block
         */
        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask(Messages.InitializingDebugger, 10);
            boolean attachExecutable = false;
            String executable = null;
            String corefile = null;
            String buildLog = null;
            String arguments = null;
            String remoteAddress = null;
            String remotePort = null;
            String pid = null;
            String[] args = Platform.getCommandLineArgs();
            try {
                try {
                    String executablePath;
                    Status errorStatus;
                    Object info;
                    int i = 0;
                    while (i < args.length) {
                        if ("-application".equals(args[i])) {
                            ++i;
                        } else if ("-product".equals(args[i])) {
                            ++i;
                        } else if ("-b".equals(args[i])) {
                            if (++i < args.length) {
                                buildLog = args[i];
                            }
                        } else if ("-a".equals(args[i])) {
                            attachExecutable = true;
                            executable = null;
                            if (i + 1 < args.length && !args[i + 1].startsWith("-")) {
                                pid = args[++i];
                            }
                        } else if ("-c".equals(args[i])) {
                            corefile = "";
                            executable = "";
                            if (++i < args.length) {
                                corefile = args[i];
                            }
                        } else if ("-r".equals(args[i])) {
                            String[] params;
                            ++i;
                            remoteAddress = "";
                            if (!attachExecutable) {
                                executable = "";
                            }
                            if (i < args.length && (params = args[i].split(":")).length == 2) {
                                remoteAddress = params[0];
                                remotePort = params[1];
                            }
                        } else if ("-e".equals(args[i])) {
                            if (++i < args.length) {
                                executable = ApplicationWorkbenchWindowAdvisor.this.findExecutable(args[i]);
                            }
                            StringBuilder argBuffer = new StringBuilder();
                            if (++i < args.length) {
                                argBuffer.append(ApplicationWorkbenchWindowAdvisor.this.escapeArg(args[i++]));
                            }
                            while (i < args.length) {
                                argBuffer.append(" ");
                                argBuffer.append(ApplicationWorkbenchWindowAdvisor.this.escapeArg(args[i++]));
                            }
                            arguments = argBuffer.toString();
                        }
                        ++i;
                    }
                    if (corefile != null) {
                        File executableFile = null;
                        if (executable != null) {
                            executableFile = new File(executable);
                            executable = executableFile.getCanonicalPath();
                        }
                        File coreFile = new File(corefile);
                        corefile = coreFile.getCanonicalPath();
                        if (executableFile == null || !executableFile.exists() || !coreFile.exists()) {
                            info = new CoreFileInfo("", "", "");
                            errorStatus = new Status(4, "GDBStandalone", 0, Messages.GdbDebugNewExecutableCommand_Binary_file_does_not_exist, null);
                            executablePath = executable;
                            String coreFilePath = corefile;
                            Display.getDefault().syncExec(() -> this.lambda$0(executablePath, coreFilePath, (CoreFileInfo)info, (IStatus)errorStatus));
                            if (((CoreFileInfo)info).getHostPath().isEmpty()) {
                                monitor.done();
                                throw new StartupException(errorStatus.getMessage());
                            }
                            executable = ((CoreFileInfo)info).getHostPath();
                            corefile = ((CoreFileInfo)info).getCoreFilePath();
                        }
                    } else if (remoteAddress != null) {
                        File executableFile = null;
                        if (executable != null) {
                            executableFile = new File(executable);
                            executable = executableFile.getCanonicalPath();
                        }
                        Integer port = null;
                        try {
                            port = Integer.parseInt(remotePort);
                        }
                        catch (NumberFormatException e) {
                            port = null;
                        }
                        if (!attachExecutable && (executableFile == null || !executableFile.exists()) || remoteAddress.length() == 0 || port == null) {
                            info = new RemoteExecutableInfo[1];
                            errorStatus = new Status(4, "GDBStandalone", 0, Messages.GdbDebugNewExecutableCommand_Binary_file_does_not_exist, null);
                            executablePath = executable;
                            String addressStr = remoteAddress;
                            String portStr = remotePort;
                            String buildLogPath = buildLog;
                            boolean attach = attachExecutable;
                            Display.getDefault().syncExec(() -> this.lambda$1(executablePath, buildLogPath, addressStr, portStr, attach, (RemoteExecutableInfo[])info, (IStatus)errorStatus));
                            if (info[0] == null) {
                                monitor.done();
                                throw new StartupException(errorStatus.getMessage());
                            }
                            executable = ((RemoteExecutableInfo)info[0]).getHostPath();
                            buildLog = ((RemoteExecutableInfo)info[0]).getBuildLog();
                            remoteAddress = ((RemoteExecutableInfo)info[0]).getAddress();
                            remotePort = ((RemoteExecutableInfo)info[0]).getPort();
                            attachExecutable = ((RemoteExecutableInfo)info[0]).isAttach();
                        }
                    } else if (executable != null) {
                        File executableFile = new File(executable);
                        executable = executableFile.getCanonicalPath();
                        File buildLogFile = null;
                        if (buildLog != null) {
                            buildLogFile = new File(buildLog);
                            buildLog = buildLogFile.getCanonicalPath();
                        }
                        if (!executableFile.exists() || buildLogFile != null && !buildLogFile.exists()) {
                            info = new NewExecutableInfo("", "", "", "");
                            errorStatus = new Status(4, "GDBStandalone", 0, Messages.GdbDebugNewExecutableCommand_Binary_file_does_not_exist, null);
                            executablePath = executable;
                            String executableArgs = arguments;
                            String buildLogPath = buildLog;
                            Display.getDefault().syncExec(() -> this.lambda$2(executablePath, buildLogPath, executableArgs, (NewExecutableInfo)info, (IStatus)errorStatus));
                            if (((NewExecutableInfo)info).getHostPath().isEmpty()) {
                                monitor.done();
                                throw new StartupException(errorStatus.getMessage());
                            }
                            executable = ((NewExecutableInfo)info).getHostPath();
                            arguments = ((NewExecutableInfo)info).getArguments();
                        }
                    }
                    monitor.worked(1);
                    if (remoteAddress != null && remoteAddress.length() > 0 && remotePort != null && remotePort.length() > 0) {
                        ApplicationWorkbenchWindowAdvisor.this.config = DebugRemoteExecutable.createLaunchConfig(monitor, buildLog, executable, remoteAddress, remotePort, attachExecutable);
                    } else if (attachExecutable) {
                        ApplicationWorkbenchWindowAdvisor.this.config = DebugAttachedExecutable.createLaunchConfig(monitor, buildLog, pid);
                    } else if (corefile != null && corefile.length() > 0) {
                        ApplicationWorkbenchWindowAdvisor.this.config = DebugCoreFile.createLaunchConfig(monitor, buildLog, executable, corefile);
                    } else if (executable != null && executable.length() > 0) {
                        ApplicationWorkbenchWindowAdvisor.this.config = DebugExecutable.importAndCreateLaunchConfig(monitor, executable, buildLog, arguments, true);
                    } else {
                        monitor.subTask(Messages.RestorePreviousLaunch);
                        String memento = ResourcesPlugin.getWorkspace().getRoot().getPersistentProperty(new QualifiedName(ApplicationWorkbenchWindowAdvisor.STANDALONE_QUALIFIER, ApplicationWorkbenchWindowAdvisor.LAST_LAUNCH));
                        if (memento != null) {
                            ApplicationWorkbenchWindowAdvisor.this.config = DebugExecutable.getLaunchManager().getLaunchConfiguration(memento);
                        }
                        String oldExecutable = "";
                        String oldArguments = "";
                        String oldBuildLog = "";
                        if (ApplicationWorkbenchWindowAdvisor.this.config != null) {
                            oldExecutable = ApplicationWorkbenchWindowAdvisor.this.config.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", "");
                            oldArguments = ApplicationWorkbenchWindowAdvisor.this.config.getAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", "");
                            oldBuildLog = ApplicationWorkbenchWindowAdvisor.this.config.getAttribute("org.eclipse.cdt.debug.application.launch.build.log", "");
                        }
                        NewExecutableInfo info2 = new NewExecutableInfo("", "", "", "");
                        Status errorStatus2 = new Status(2, "GDBStandalone", 0, Messages.GdbDebugNewExecutableCommand_Binary_file_does_not_exist, null);
                        String executablePath2 = oldExecutable;
                        String executableArgs = oldArguments;
                        String buildLogPath = oldBuildLog;
                        Display.getDefault().syncExec(() -> this.lambda$3(executablePath2, buildLogPath, executableArgs, info2, (IStatus)errorStatus2));
                        if (info2.getHostPath().isEmpty()) {
                            monitor.done();
                            throw new StartupException(errorStatus2.getMessage());
                        }
                        executable = info2.getHostPath();
                        arguments = info2.getArguments();
                        buildLog = info2.getBuildLog();
                        if (ApplicationWorkbenchWindowAdvisor.this.config == null || !executable.equals(oldExecutable)) {
                            ApplicationWorkbenchWindowAdvisor.this.config = DebugExecutable.importAndCreateLaunchConfig(monitor, executable, buildLog, arguments, true);
                        }
                        ILaunchConfigurationWorkingCopy wc = ApplicationWorkbenchWindowAdvisor.this.config.getWorkingCopy();
                        wc.setAttribute("org.eclipse.cdt.debug.application.launch.build.log", buildLog);
                        if (arguments != null) {
                            wc.setAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", arguments);
                        }
                        ApplicationWorkbenchWindowAdvisor.this.config = wc.doSave();
                        monitor.worked(7);
                    }
                    if (ApplicationWorkbenchWindowAdvisor.this.config != null) {
                        final JobContainer LaunchJobs = new JobContainer();
                        Job.getJobManager().addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                            public void scheduled(IJobChangeEvent event) {
                                Job job = event.getJob();
                                if (job.getName().contains(((PostWindowCreateRunnable)PostWindowCreateRunnable.this).ApplicationWorkbenchWindowAdvisor.this.config.getName())) {
                                    LaunchJobs.setLaunchJob(job);
                                }
                            }

                            public void done(IJobChangeEvent event) {
                            }
                        });
                        monitor.subTask(Messages.LaunchingConfig);
                        Display.getDefault().syncExec(() -> DebugUITools.launch((ILaunchConfiguration)ApplicationWorkbenchWindowAdvisor.this.config, (String)"debug"));
                        if (LaunchJobs.getLaunchJob() != null) {
                            try {
                                LaunchJobs.getLaunchJob().join();
                            }
                            catch (InterruptedException e) {
                                Status status = new Status(4, "GDBStandalone", 0, Messages.LaunchInterruptedError, (Throwable)e);
                                ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
                            }
                        }
                    }
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    monitor.done();
                }
                catch (StartupException e) {
                    monitor.done();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
        }

        private /* synthetic */ void lambda$0(String string, String string2, CoreFileInfo coreFileInfo, IStatus iStatus) {
            CoreFileDialog dialog = new CoreFileDialog(ApplicationWorkbenchWindowAdvisor.this.getWindowConfigurer().getWindow().getShell(), 0, string, string2);
            dialog.setBlockOnOpen(true);
            if (dialog.open() == 0) {
                CoreFileInfo info2 = dialog.getCoreFileInfo();
                coreFileInfo.setHostPath(info2.getHostPath());
                coreFileInfo.setCoreFilePath(info2.getCoreFilePath());
            } else {
                ErrorDialog.openError(null, (String)Messages.DebuggerInitializingProblem, null, (IStatus)iStatus, (int)6);
            }
        }

        private /* synthetic */ void lambda$1(String string, String string2, String string3, String string4, boolean bl, RemoteExecutableInfo[] remoteExecutableInfoArray, IStatus iStatus) {
            RemoteExecutableDialog dialog = new RemoteExecutableDialog(ApplicationWorkbenchWindowAdvisor.this.getWindowConfigurer().getWindow().getShell(), string, string2, string3, string4, bl);
            dialog.setBlockOnOpen(true);
            if (dialog.open() == 0) {
                remoteExecutableInfoArray[0] = dialog.getExecutableInfo();
            } else {
                remoteExecutableInfoArray[0] = null;
                ErrorDialog.openError(null, (String)Messages.DebuggerInitializingProblem, null, (IStatus)iStatus, (int)6);
            }
        }

        private /* synthetic */ void lambda$2(String string, String string2, String string3, NewExecutableInfo newExecutableInfo, IStatus iStatus) {
            NewExecutableDialog dialog = new NewExecutableDialog(ApplicationWorkbenchWindowAdvisor.this.getWindowConfigurer().getWindow().getShell(), 0, string, string2, string3);
            dialog.setBlockOnOpen(true);
            if (dialog.open() == 0) {
                NewExecutableInfo info2 = dialog.getExecutableInfo();
                newExecutableInfo.setHostPath(info2.getHostPath());
                newExecutableInfo.setArguments(info2.getArguments());
            } else {
                ErrorDialog.openError(null, (String)Messages.DebuggerInitializingProblem, null, (IStatus)iStatus, (int)6);
            }
        }

        private /* synthetic */ void lambda$3(String string, String string2, String string3, NewExecutableInfo newExecutableInfo, IStatus iStatus) {
            NewExecutableDialog dialog = new NewExecutableDialog(ApplicationWorkbenchWindowAdvisor.this.getWindowConfigurer().getWindow().getShell(), 0, string, string2, string3);
            dialog.setBlockOnOpen(true);
            if (dialog.open() == 0) {
                NewExecutableInfo info2 = dialog.getExecutableInfo();
                newExecutableInfo.setHostPath(info2.getHostPath());
                newExecutableInfo.setArguments(info2.getArguments());
                newExecutableInfo.setBuildLog(info2.getBuildLog());
            } else {
                ErrorDialog.openError(null, (String)Messages.DebuggerInitializingProblem, null, (IStatus)iStatus, (int)6);
            }
        }
    }

    private class StartupException
    extends FileNotFoundException {
        private static final long serialVersionUID = 1L;

        public StartupException(String s) {
        }
    }
}

