/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.logging.aeri.core;

import java.io.IOException;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.core.contexts.IEclipseContext;

public interface IServerConnection {

    /**
     * Asks the end-point whether it is generally interested in this status. Note that there is no guarantee that
     * {@link #submit(IStatus, IEclipseContext, IProgressMonitor)} or {@link #discarded(IStatus, IEclipseContext)} will be called for this
     * status.
     *
     * @param status
     *            the logged status. The status may have been modified to guarantee that {@link IStatus#getException()} never returns
     *            <code>null</code>.
     * @param eventScopeContext
     *            the eclipse context for this status object. The context is stable over the whole life-cycle of the given IStatus object.
     */
    IProblemState interested(IStatus status, IEclipseContext eventScopeContext, IProgressMonitor monitor);

    /**
     * Asks the end-point to transform the given {@link IStatus} with the given {@link ISendOptions} to a {@link Report}. This method may be
     * called several times with the same status but different send options. Although likely, there is no guarantee that the user has seen
     * the report at this point in time.
     */
    IReport transform(IStatus status, IEclipseContext eventScopeContext);

    /**
     * Asks the end-point to send the given status. The transformation should be done based on the {@link ISendOptions} provided in the
     * {@link IEclipseContext}.
     *
     * @param status
     *            the status to be send
     * @param eventScopeContext
     *            the eclipse context for this log event
     */
    IProblemState submit(IStatus status, IEclipseContext eventScopeContext, IProgressMonitor monitor) throws IOException;

    /**
     * Informs the end-point that the user discarded the provided report.
     *
     * @param status
     *            the status that was ignored
     * @param eventScopeContext
     *            the event scope context
     */
    void discarded(IStatus status, IEclipseContext eventScopeContext);
}
