/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.testing;

import com.google.common.annotations.Beta;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.junit.Assert;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

@Documented
@Target(value={ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
@Beta
public @interface Flaky {
    public int trials() default 3;

    public static class Rule
    implements TestRule {
        public Statement apply(Statement base, Description description) {
            Flaky flaky = (Flaky)description.getAnnotation(Flaky.class);
            if (flaky == null) {
                return base;
            }
            int trials = flaky.trials();
            return new RepeatedStatement(base, trials);
        }

        private static class RepeatedStatement
        extends Statement {
            private final Statement base;
            private final int trials;

            public RepeatedStatement(Statement base, int trials) {
                this.base = base;
                this.trials = trials;
            }

            public void evaluate() throws Throwable {
                if (this.trials <= 1 || this.trials > 100) {
                    throw new IllegalArgumentException("Illegal number of trials: " + this.trials + ", must be between 2 and 100 (inclusive)");
                }
                Throwable firstError = null;
                for (int remaining = this.trials; remaining > 0; --remaining) {
                    try {
                        this.base.evaluate();
                        return;
                    }
                    catch (Throwable t) {
                        if (firstError != null) continue;
                        firstError = t;
                        continue;
                    }
                }
                Assert.assertNotNull(firstError);
                throw firstError;
            }
        }
    }
}

