/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define(["require", "exports", "./data/html5"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var html5_1 = require("./data/html5");
    exports.builtinDataProviders = [
        html5_1.getHTML5DataProvider()
    ];
    var customDataProviders = [];
    function getAllDataProviders() {
        return exports.builtinDataProviders.concat(customDataProviders);
    }
    exports.getAllDataProviders = getAllDataProviders;
    function handleCustomDataProviders(providers) {
        providers.forEach(function (p) {
            customDataProviders.push(p);
        });
    }
    exports.handleCustomDataProviders = handleCustomDataProviders;
});
