/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.debug.firefox;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.lsp4e.debug.launcher.DSPLaunchDelegate;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wildwebdeveloper.Activator;
import org.eclipse.wildwebdeveloper.InitializeLaunchConfigurations;
import org.eclipse.wildwebdeveloper.debug.firefox.FirefoxRunDABDebugDelegate;

public class FirefoxAttachDebugDelegate
extends DSPLaunchDelegate {
    static final String ID = "org.eclipse.wildwebdeveloper.launchConfiguration.nodeDebug";
    static final String PORT = "port";
    static final String REQUEST = "request";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put(REQUEST, "attach");
        int port = configuration.getAttribute(PORT, 4711);
        param.put(PORT, port);
        try {
            List<String> debugCmdArgs = Collections.singletonList(FirefoxRunDABDebugDelegate.findDebugAdapter().getAbsolutePath());
            DSPLaunchDelegate.DSPLaunchDelegateLaunchBuilder builder = new DSPLaunchDelegate.DSPLaunchDelegateLaunchBuilder(configuration, mode, launch, monitor);
            builder.setLaunchDebugAdapter(InitializeLaunchConfigurations.getNodeJsLocation(), debugCmdArgs);
            builder.setMonitorDebugAdapter(configuration.getAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_MONITOR_ADAPTER", false));
            builder.setDspParameters(param);
            super.launch(builder);
        }
        catch (IOException | URISyntaxException e) {
            Status errorStatus = new Status(4, "org.eclipse.wildwebdeveloper", e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)errorStatus);
            ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Debug error", (String)e.getMessage(), (IStatus)errorStatus);
        }
    }
}

