/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.internal.logging.aeri.ide;

import org.eclipse.emf.ecore.EFactory;

/**
 * <!-- begin-user-doc -->
 * The <b>Factory</b> for the model.
 * It provides a create method for each non-abstract class of the model.
 * <!-- end-user-doc -->
 * @see org.eclipse.epp.internal.logging.aeri.ide.IIdePackage
 * @generated
 */
public interface IIdeFactory extends EFactory {
	/**
	 * The singleton instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	IIdeFactory eINSTANCE = org.eclipse.epp.internal.logging.aeri.ide.impl.IdeFactoryImpl.init();

	/**
	 * Returns a new object of class '<em>Log Events Queue</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Log Events Queue</em>'.
	 * @generated
	 */
	ILogEventsQueue createLogEventsQueue();

	/**
	 * Returns a new object of class '<em>Log Event Group</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Log Event Group</em>'.
	 * @generated
	 */
	ILogEventGroup createLogEventGroup();

	/**
	 * Returns a new object of class '<em>Log Event</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Log Event</em>'.
	 * @generated
	 */
	ILogEvent createLogEvent();

	/**
	 * Returns a new object of class '<em>Internal Input</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Internal Input</em>'.
	 * @generated
	 */
	IInternalInput createInternalInput();

	/**
	 * Returns a new object of class '<em>Server Descriptor</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Server Descriptor</em>'.
	 * @generated
	 */
	IServerDescriptor createServerDescriptor();

	/**
	 * Returns a new object of class '<em>Processor Descriptor</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Processor Descriptor</em>'.
	 * @generated
	 */
	IProcessorDescriptor createProcessorDescriptor();

	/**
	 * Returns the package supported by this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the package supported by this factory.
	 * @generated
	 */
	IIdePackage getIdePackage();

} //IIdeFactory
