/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views.graph.figures;

import org.eclipse.datatools.sqltools.sqlbuilder.SQLBuilderPlugin;
import org.eclipse.datatools.sqltools.sqlbuilder.views.graph.figures.FlatEndConnectionRouter;
import org.eclipse.draw2d.AnchorListener;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.PositionConstants;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class TableConnection
extends PolylineConnection
implements PositionConstants,
Connection,
AnchorListener {
    private ConnectionRouter connectionRouter = new FlatEndConnectionRouter();
    protected ConnectionAnchor sourceAnchor;
    protected ConnectionAnchor targetAnchor;
    protected Label joinTypeIcon;
    protected PolygonDecoration startShape;
    protected PolygonDecoration endShape;
    protected static final PointList FUNNEL_SHAPE = new PointList();
    protected static final Image innerJoin;
    protected static final Image outerJoin;
    protected static final Image leftOuterJoin;
    protected static final Image rightOuterJoin;

    static {
        FUNNEL_SHAPE.addPoint(0, 1);
        FUNNEL_SHAPE.addPoint(0, -1);
        FUNNEL_SHAPE.addPoint(-1, 0);
        innerJoin = SQLBuilderPlugin.getSQLImage("icons/innerjoin.gif");
        outerJoin = SQLBuilderPlugin.getSQLImage("icons/outerjoin.gif");
        leftOuterJoin = SQLBuilderPlugin.getSQLImage("icons/outerjoin_left.gif");
        rightOuterJoin = SQLBuilderPlugin.getSQLImage("icons/outerjoin_right.gif");
    }

    public TableConnection() {
        this.setOutline(true);
        this.joinTypeIcon = new Label("");
        this.joinTypeIcon.setLabelAlignment(1);
        this.joinTypeIcon.setTextPlacement(20);
        this.setJoinType(0);
        this.startShape = new PolygonDecoration();
        this.startShape.setBackgroundColor(ColorConstants.buttonDarker);
        this.startShape.setTemplate(FUNNEL_SHAPE);
        this.startShape.setScale(6.0, 3.0);
        this.endShape = new PolygonDecoration();
        this.endShape.setBackgroundColor(ColorConstants.buttonDarker);
        this.endShape.setTemplate(FUNNEL_SHAPE);
        this.endShape.setScale(6.0, 3.0);
        this.add((IFigure)this.startShape);
        this.add((IFigure)this.endShape);
        this.add((IFigure)this.joinTypeIcon);
    }

    public void setJoinType(int joinType) {
        switch (joinType) {
            case 0: {
                this.joinTypeIcon.setIcon(innerJoin);
                break;
            }
            case 2: {
                this.joinTypeIcon.setIcon(leftOuterJoin);
                break;
            }
            case 3: {
                this.joinTypeIcon.setIcon(rightOuterJoin);
                break;
            }
            case 4: {
                this.joinTypeIcon.setIcon(outerJoin);
            }
        }
    }

    public ConnectionRouter getConnectionRouter() {
        if (this.connectionRouter != null) {
            return this.connectionRouter;
        }
        return super.getConnectionRouter();
    }

    public ConnectionAnchor getSourceAnchor() {
        return this.sourceAnchor;
    }

    public ConnectionAnchor getTargetAnchor() {
        return this.targetAnchor;
    }

    public void removeNotify() {
        this.getConnectionRouter().remove((Connection)this);
        super.removeNotify();
    }

    public void setConnectionRouter(ConnectionRouter cr) {
        this.connectionRouter = cr == null ? new FlatEndConnectionRouter() : cr;
    }

    public void setTargetAnchor(ConnectionAnchor anchor) {
        if (this.targetAnchor != null) {
            this.targetAnchor.removeAnchorListener((AnchorListener)this);
        }
        if (anchor != null) {
            anchor.addAnchorListener((AnchorListener)this);
        }
        this.targetAnchor = anchor;
        this.revalidate();
    }

    public void setSourceAnchor(ConnectionAnchor anchor) {
        if (this.sourceAnchor != null) {
            this.sourceAnchor.removeAnchorListener((AnchorListener)this);
        }
        if (anchor != null) {
            anchor.addAnchorListener((AnchorListener)this);
        }
        this.sourceAnchor = anchor;
        this.revalidate();
    }

    public void anchorMoved(ConnectionAnchor anchor) {
        this.revalidate();
    }

    public PointList getPoints() {
        return super.getPoints();
    }

    public PointList getThickPoints() {
        Point currentPoint;
        PointList thickpoints = new PointList();
        PointList points = this.getPoints();
        int numPoints = points.size();
        int i = 0;
        while (i < numPoints) {
            currentPoint = points.getPoint(i);
            --currentPoint.y;
            thickpoints.addPoint(currentPoint);
            ++i;
        }
        i = numPoints - 1;
        while (i >= 0) {
            currentPoint = points.getPoint(i);
            ++currentPoint.y;
            thickpoints.addPoint(currentPoint);
            --i;
        }
        return thickpoints;
    }

    public void setPoints(PointList newPoints) {
        int numPoints = newPoints.size();
        int i = 0;
        while (i < numPoints) {
            Point currentPoint = newPoints.getPoint(i);
            this.addPoint(currentPoint);
            ++i;
        }
    }

    protected void fillShape(Graphics g) {
        g.fillPolygon(this.getThickPoints());
    }

    protected void outlineShape(Graphics g) {
        g.setLineWidth(3);
        super.outlineShape(g);
        this.setLineWidth(1);
        this.setForegroundColor(this.getBackgroundColor());
        super.outlineShape(g);
    }

    public org.eclipse.draw2d.geometry.Rectangle getBounds() {
        if (this.bounds == null) {
            super.getBounds();
            if (this.joinTypeIcon != null) {
                this.bounds.union(this.joinTypeIcon.getBounds());
            }
            if (this.startShape != null) {
                this.bounds.union(this.startShape.getBounds());
            }
            if (this.endShape != null) {
                this.bounds.union(this.endShape.getBounds());
            }
        }
        return this.bounds;
    }

    public void layout() {
        if (this.getSourceAnchor() != null && this.getTargetAnchor() != null) {
            this.getConnectionRouter().route((Connection)this);
        }
        super.layout();
        this.bounds = null;
        this.fireMoved();
    }

    public void validate() {
        if (this.isValid()) {
            return;
        }
        this.erase();
        if (this.getLayoutManager() == null && this.getSourceAnchor() != null && this.getTargetAnchor() != null) {
            Point center = this.getTargetAnchor().getReferencePoint();
            this.setStart(this.getSourceAnchor().getLocation(center));
            center = this.getSourceAnchor().getReferencePoint();
            this.setEnd(this.getTargetAnchor().getLocation(center));
        }
        super.validate();
        if (this.getSourceAnchor().getOwner() != null && this.getTargetAnchor().getOwner() != null) {
            this.validateJoinIcon();
            this.validateStartShape();
            this.validateEndShape();
            this.repaint();
        }
    }

    protected void validateStartShape() {
        if (this.startShape == null) {
            return;
        }
        this.startShape.setLocation(this.getStart());
        this.startShape.setReferencePoint(super.getPoints().getPoint(1));
        this.bounds = null;
    }

    protected void validateEndShape() {
        if (this.endShape == null) {
            return;
        }
        Point endPoint = this.getEnd();
        ++endPoint.x;
        this.endShape.setLocation(endPoint);
        this.endShape.setReferencePoint(super.getPoints().getPoint(2));
        this.bounds = null;
    }

    protected void validateJoinIcon() {
        PointList points = super.getPoints();
        Point leftPoint = points.getPoint(1);
        Point rightPoint = points.getPoint(2);
        int minX = Math.min(leftPoint.x, rightPoint.x);
        int maxX = Math.max(leftPoint.x, rightPoint.x);
        int minY = Math.min(leftPoint.y, rightPoint.y);
        int maxY = Math.max(leftPoint.y, rightPoint.y);
        Rectangle imageRect = this.joinTypeIcon.getIcon().getBounds();
        int x = minX + (maxX - minX) / 2 - imageRect.width / 2;
        int y = minY + (maxY - minY) / 2 - imageRect.height / 2;
        Point newPoint = new Point(x, y);
        this.joinTypeIcon.setLocation(newPoint);
        this.joinTypeIcon.setBounds(this.joinTypeIcon.getIconBounds());
        this.bounds = null;
    }

    public Object getRoutingConstraint() {
        return null;
    }

    public void setRoutingConstraint(Object cons) {
    }
}

