/*******************************************************************************
 * Copyright (c) 2004 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Actuate Corporation  - initial API and implementation
 *******************************************************************************/

package org.eclipse.birt.report.debug.internal.script.model;

import org.eclipse.birt.report.debug.internal.ui.script.actions.ScriptRunToLineAdapter;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.debug.ui.actions.IRunToLineTarget;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;

/**
 * ScriptBreakpointAdapterFactory
 */
public class ScriptBreakpointAdapterFactory implements IAdapterFactory
{

	/* (non-Javadoc)
	 * @see org.eclipse.core.runtime.IAdapterFactory#getAdapter(java.lang.Object, java.lang.Class)
	 */
	public Object getAdapter( Object adaptableObject, Class adapterType )
	{
		if (adapterType == IRunToLineTarget.class) {
			
			return new ScriptRunToLineAdapter();
		}
		else if (adapterType == IToggleBreakpointsTarget.class)
		{
			return new ScriptLineBreakpointAdapter( );
		}
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.core.runtime.IAdapterFactory#getAdapterList()
	 */
	public Class[] getAdapterList( )
	{
		return new Class[]{
			IToggleBreakpointsTarget.class, IRunToLineTarget.class
		};
	}

}
