/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.shared.ui.editor;

import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;
import org.eclipse.xtend.shared.ui.Activator;
import org.eclipse.xtend.shared.ui.Messages;
import org.eclipse.xtend.shared.ui.editor.BreakpointActionGroup;

public class EnableDisableBreakpointAction
extends Action {
    private final TextEditor editor;
    private final BreakpointActionGroup group;
    private IBreakpoint fBreakpoint;

    protected EnableDisableBreakpointAction(TextEditor editor, BreakpointActionGroup group) {
        this.editor = editor;
        this.group = group;
        this.setToolTipText(Messages.EnableDisableBreakpointAction_Description);
    }

    public void updateText() {
        block5: {
            this.fBreakpoint = this.getBreakpoint();
            this.setEnabled(this.fBreakpoint != null);
            if (this.fBreakpoint != null) {
                try {
                    if (this.fBreakpoint.isEnabled()) {
                        this.setText(Messages.EnableDisableBreakpointAction_DisableAction);
                        break block5;
                    }
                    this.setText(Messages.EnableDisableBreakpointAction_EnableAction);
                }
                catch (CoreException coreException) {}
            } else {
                this.setText(Messages.EnableDisableBreakpointAction_DisableAction);
            }
        }
    }

    public void run() {
        if (this.fBreakpoint != null) {
            try {
                this.fBreakpoint.setEnabled(!this.fBreakpoint.isEnabled());
            }
            catch (CoreException e) {
                Activator.logError(Messages.EnableDisableBreakpointAction_Error, (Exception)((Object)e));
            }
        }
    }

    protected IBreakpoint getBreakpoint() {
        boolean isRulerSelected = this.group.isRulerSelected();
        int selectedLine = this.group.getLastSelectedLine();
        int selectedOffset = this.group.getLastSelectedOffset();
        IAnnotationModel annotationModel = this.editor.getDocumentProvider().getAnnotationModel((Object)this.editor.getEditorInput());
        IDocument document = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
        if (annotationModel != null) {
            Iterator iterator = annotationModel.getAnnotationIterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (!(object instanceof SimpleMarkerAnnotation)) continue;
                SimpleMarkerAnnotation markerAnnotation = (SimpleMarkerAnnotation)object;
                IMarker marker = markerAnnotation.getMarker();
                try {
                    IBreakpoint breakpoint;
                    if (!marker.isSubtypeOf(IBreakpoint.BREAKPOINT_MARKER)) continue;
                    Position position = annotationModel.getPosition((Annotation)markerAnnotation);
                    int line = document.getLineOfOffset(position.offset);
                    if ((!isRulerSelected || line != selectedLine) && (isRulerSelected || selectedOffset < position.offset || selectedOffset > position.offset + position.length) || (breakpoint = DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(marker)) == null) continue;
                    return breakpoint;
                }
                catch (CoreException coreException) {
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
        return null;
    }
}

