import { DebugProtocol } from 'vscode-debugprotocol';
import { LoggingDebugSession } from 'vscode-debugadapter';
import { ChromeDebugAdapter } from './chromeDebugAdapter';
import { ITargetFilter, ChromeConnection } from './chromeConnection';
import { BasePathTransformer } from '../transformers/basePathTransformer';
import { BaseSourceMapTransformer } from '../transformers/baseSourceMapTransformer';
import { LineColTransformer } from '../transformers/lineNumberTransformer';
import { StepProgressEventsEmitter, IObservableEvents, IStepStartedEventsEmitter, IFinishedStartingUpEventsEmitter } from '../executionTimingsReporter';
export interface IChromeDebugAdapterOpts {
    targetFilter?: ITargetFilter;
    logFilePath?: string;
    chromeConnection?: typeof ChromeConnection;
    pathTransformer?: {
        new (): BasePathTransformer;
    };
    sourceMapTransformer?: {
        new (sourceHandles: any): BaseSourceMapTransformer;
    };
    lineColTransformer?: {
        new (session: any): LineColTransformer;
    };
}
export interface IChromeDebugSessionOpts extends IChromeDebugAdapterOpts {
    /** The class of the adapter, which is instantiated for each session */
    adapter: typeof ChromeDebugAdapter;
    extensionName: string;
}
export declare const ErrorTelemetryEventName = "error";
export declare class ChromeDebugSession extends LoggingDebugSession implements IObservableEvents<IStepStartedEventsEmitter & IFinishedStartingUpEventsEmitter> {
    private readonly _readyForUserTimeoutInMilliseconds;
    private _debugAdapter;
    private _extensionName;
    readonly events: StepProgressEventsEmitter;
    private reporter;
    private haveTimingsWhileStartingUpBeenReported;
    static readonly FinishedStartingUpEventName: string;
    /**
     * This needs a bit of explanation -
     * The Session is reinstantiated for each session, but consumers need to configure their instance of
     * ChromeDebugSession. Consumers should call getSession with their config options, then call
     * DebugSession.run with the result. Alternatively they could subclass ChromeDebugSession and pass
     * their options to the super constructor, but I think this is easier to follow.
     */
    static getSession(opts: IChromeDebugSessionOpts): typeof ChromeDebugSession;
    constructor(obsolete_debuggerLinesAndColumnsStartAt1?: boolean, obsolete_isServer?: boolean, opts?: IChromeDebugSessionOpts);
    /**
     * Overload dispatchRequest to the debug adapters' Promise-based methods instead of DebugSession's callback-based methods
     */
    protected dispatchRequest(request: DebugProtocol.Request): void;
    private reportTelemetry(eventName, action);
    private isEvaluateRequest(requestType, error);
    private failedRequest(requestType, response, error);
    private sendUnknownCommandResponse(response, command);
    reportTimingsWhileStartingUpIfNeeded(requestedContentWasDetected: boolean, reasonForNotDetected?: string): void;
    private configureExecutionTimingsReporting();
    shutdown(): void;
    sendResponse(response: DebugProtocol.Response): void;
}
