/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.collections;

import org.eclipse.mat.inspections.collectionextract.AbstractExtractedCollection;
import org.eclipse.mat.inspections.collectionextract.CollectionExtractionUtils;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.query.ObjectListResult;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;

@CommandName(value="extract_list_values")
@Icon(value="/META-INF/icons/list.gif")
@HelpUrl(value="/org.eclipse.mat.ui.help/tasks/analyzingjavacollectionusage.html")
public class ExtractListValuesQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(flag="none")
    public IObject list;

    public IResult execute(IProgressListener listener) throws Exception {
        AbstractExtractedCollection<?, ?> extractor = CollectionExtractionUtils.extractCollection(this.list);
        if (extractor != null && extractor.hasExtractableContents()) {
            return new ObjectListResult.Outbound(this.snapshot, extractor.extractEntryIds());
        }
        throw new IllegalArgumentException(MessageUtil.format((String)Messages.ExtractListValuesQuery_NotAWellKnownList, (Object[])new Object[]{this.list.getDisplayName()}));
    }
}

