/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.ui.SWTImagesFactory;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImageRunNetworkModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ImageRunNetworkPage
extends WizardPage {
    private final int COLUMNS = 2;
    private static final String NETWORK_MODE = "networkMode";
    private final DataBindingContext dbc = new DataBindingContext();
    private final ImageRunNetworkModel model;
    private final ILaunchConfiguration lastLaunchConfiguration;
    private Control containerControl;
    private Control otherControl;

    public ImageRunNetworkPage(IDockerConnection connection) {
        super("ImageRunNetworkPage", WizardMessages.getString("ImageRunNetworkPage.title"), SWTImagesFactory.DESC_BANNER_REPOSITORY);
        this.setPageComplete(true);
        this.model = new ImageRunNetworkModel(connection);
        this.lastLaunchConfiguration = null;
    }

    public ImageRunNetworkPage(IDockerImage selectedImage, ILaunchConfiguration lastLaunchConfiguration) {
        super("ImageRunNetworkPage", WizardMessages.getString("ImageRunNetworkPage.title"), SWTImagesFactory.DESC_BANNER_REPOSITORY);
        this.setPageComplete(true);
        this.model = new ImageRunNetworkModel(selectedImage);
        this.lastLaunchConfiguration = lastLaunchConfiguration;
    }

    public ImageRunNetworkModel getModel() {
        return this.model;
    }

    public void createControl(Composite parent) {
        ScrolledComposite scrollTop = new ScrolledComposite(parent, 768);
        scrollTop.setExpandVertical(true);
        scrollTop.setExpandHorizontal(true);
        Composite container = new Composite((Composite)scrollTop, 0);
        container.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().align(4, 4).span(1, 1).grab(true, false).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(6, 6).applyTo(container);
        this.createNetworkModeContainer(container);
        this.setDefaultValues();
        scrollTop.setContent((Control)container);
        Point point = container.computeSize(-1, -1);
        scrollTop.setSize(point);
        scrollTop.setMinSize(point);
        this.setControl((Control)scrollTop);
    }

    private void createNetworkModeContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().align(4, 4).span(2, 1).grab(true, false).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().spacing(10, 2).applyTo(container);
        Label modeLabel = new Label(container, 0);
        modeLabel.setText(WizardMessages.getString("ImageRunNetworkPage.mode"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).grab(false, false).applyTo((Control)modeLabel);
        int COLUMNS = 2;
        int INDENT = 20;
        Composite subContainer = new Composite(container, 0);
        GridDataFactory.fillDefaults().align(4, 4).indent(20, 0).span(2, 1).grab(true, false).applyTo((Control)subContainer);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(6, 6).spacing(10, 5).applyTo(subContainer);
        modeLabel.setEnabled(true);
        Button defaultButton = new Button(subContainer, 16);
        this.bindButton(defaultButton, "");
        defaultButton.setText(WizardMessages.getString("ImageRunNetworkPage.mode.default"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).applyTo((Control)defaultButton);
        Button bridgeButton = new Button(subContainer, 16);
        bridgeButton.setText(WizardMessages.getString("ImageRunNetworkPage.mode.bridge"));
        this.bindButton(bridgeButton, "bridge");
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).applyTo((Control)bridgeButton);
        Button hostButton = new Button(subContainer, 16);
        hostButton.setText(WizardMessages.getString("ImageRunNetworkPage.mode.host"));
        this.bindButton(hostButton, "host");
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).applyTo((Control)hostButton);
        Button noneButton = new Button(subContainer, 16);
        noneButton.setText(WizardMessages.getString("ImageRunNetworkPage.mode.none"));
        this.bindButton(noneButton, "none");
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).applyTo((Control)noneButton);
        Button containerButton = new Button(subContainer, 16);
        containerButton.setText(WizardMessages.getString("ImageRunNetworkPage.mode.container"));
        this.bindButton(containerButton, "container");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)containerButton);
        Combo containerList = new Combo(subContainer, 2048);
        this.setContainerControl((Control)containerList);
        containerList.setItems(this.model.getContainerNames().toArray(new String[0]));
        if (containerList.getItemCount() > 0) {
            containerList.select(0);
        }
        containerList.setEnabled(false);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)containerList);
        this.dbc.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)containerList), BeanProperties.value(ImageRunNetworkModel.class, (String)"selectedContainer").observe((Object)this.model));
        containerButton.addSelectionListener(this.onContainerSelection(containerButton, containerList));
        Button otherButton = new Button(subContainer, 16);
        otherButton.setText(WizardMessages.getString("ImageRunNetworkPage.mode.other"));
        this.bindButton(otherButton, "other");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)otherButton);
        Text otherText = new Text(subContainer, 2052);
        this.setOtherControl((Control)otherText);
        otherText.setEnabled(false);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)otherText);
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)otherText), BeanProperties.value(ImageRunNetworkModel.class, (String)"otherString").observe((Object)this.model));
        otherButton.addSelectionListener(this.onOtherSelection(otherButton, otherText));
    }

    public boolean isPageComplete() {
        if (this.model == null) {
            return false;
        }
        if ("container".equals(this.model.getNetworkMode())) {
            if (((Combo)this.getContainerControl()).getText().isEmpty()) {
                this.setMessage(WizardMessages.getString("WarningNoContainerSelected.msg"), 2);
                return false;
            }
            if ("other".equals(this.model.getNetworkMode()) && ((Text)this.getOtherControl()).getText().isEmpty()) {
                this.setMessage(WizardMessages.getString("WarningOtherFieldEmpty.msg"), 2);
                return false;
            }
        }
        this.setMessage(null, 2);
        return true;
    }

    private Control getContainerControl() {
        return this.containerControl;
    }

    private void setContainerControl(Control containerControl) {
        this.containerControl = containerControl;
    }

    private Control getOtherControl() {
        return this.otherControl;
    }

    private void setOtherControl(Control containerControl) {
        this.otherControl = containerControl;
    }

    private Binding bindButton(Button button, final String strValue) {
        return this.dbc.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)button), BeanProperties.value(ImageRunNetworkModel.class, (String)NETWORK_MODE).observe((Object)this.model), new UpdateValueStrategy(){

            public Object convert(Object value) {
                if (value.equals(Boolean.TRUE)) {
                    return strValue;
                }
                return null;
            }
        }, new UpdateValueStrategy(){

            public Object convert(Object value) {
                return value.equals(strValue);
            }
        });
    }

    private SelectionListener onContainerSelection(Button containerButton, Combo containerList) {
        return SelectionListener.widgetSelectedAdapter(e -> {
            boolean selection = containerButton.getSelection();
            containerList.setEnabled(selection);
        });
    }

    private SelectionListener onOtherSelection(Button otherButton, Text otherText) {
        return SelectionListener.widgetSelectedAdapter(e -> {
            boolean selection = otherButton.getSelection();
            otherText.setEnabled(selection);
        });
    }

    private void setDefaultValues() {
        block17: {
            try {
                if (this.lastLaunchConfiguration == null) break block17;
                String networkModeString = this.lastLaunchConfiguration.getAttribute(NETWORK_MODE, "");
                if (networkModeString.startsWith("container")) {
                    String[] token = networkModeString.split(":");
                    this.model.setNetworkMode("container");
                    if (token.length > 1) {
                        this.model.setSelectedContainer(token[1]);
                    }
                    this.getContainerControl().setEnabled(true);
                    break block17;
                }
                switch (networkModeString) {
                    case "bridge": 
                    case "": 
                    case "host": 
                    case "none": {
                        this.model.setNetworkMode(networkModeString);
                        break;
                    }
                    default: {
                        this.model.setNetworkMode("other");
                        this.model.setOtherString(networkModeString);
                        this.getOtherControl().setEnabled(true);
                        break;
                    }
                }
            }
            catch (CoreException e) {
                Activator.log(e);
            }
        }
    }
}

