/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.editor.syntax;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.linuxtools.internal.docker.editor.Activator;
import org.eclipse.linuxtools.internal.docker.editor.DockerEditor;
import org.eclipse.linuxtools.internal.docker.editor.syntax.SyntaxProblemReporter;

public class SyntaxReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private DockerEditor editor;
    private IDocument document;

    public SyntaxReconcilingStrategy(DockerEditor editor) {
        this.editor = editor;
    }

    public void setDocument(IDocument document) {
        this.document = document;
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        try {
            IResource resource = (IResource)this.editor.getEditorInput().getAdapter(IResource.class);
            new SyntaxProblemReporter().checkAndApply(this.document, subRegion.getOffset(), subRegion.getLength(), resource);
        }
        catch (CoreException | BadLocationException e) {
            Activator.log(4, "Failed to perform syntax check", e);
        }
    }

    public void reconcile(IRegion partition) {
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
    }

    public void initialReconcile() {
    }
}

