/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.ui.text.rules;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ruby.core.utils.RubySyntaxUtils;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class RubyPercentStringRule
implements IPredicateRule {
    private static final char ESCAPE = '\\';
    protected static final int UNDEFINED = -1;
    protected IToken fToken;
    protected int fColumn = -1;
    protected boolean fEscapeContinuesLine;
    protected boolean fBreaksOnEOL;
    protected boolean fBreaksOnEOF;
    private Comparator<char[]> fLineDelimiterComparator = new DecreasingCharArrayLengthComparator();
    private char[][] fLineDelimiters;
    private char[][] fSortedLineDelimiters;

    public RubyPercentStringRule(IToken token, boolean breaksOnEOL) {
        Assert.isNotNull((Object)token);
        this.fToken = token;
        this.fBreaksOnEOL = breaksOnEOL;
        this.fBreaksOnEOF = false;
    }

    public void setColumnConstraint(int column) {
        if (column < 0) {
            column = -1;
        }
        this.fColumn = column;
    }

    protected IToken doEvaluate(ICharacterScanner scanner) {
        return this.doEvaluate(scanner, false);
    }

    protected IToken doEvaluate(ICharacterScanner scanner, boolean resume) {
        int c;
        if (!resume && (c = scanner.read()) == 37) {
            char leader;
            char term;
            if (scanner.getColumn() > 1) {
                scanner.unread();
                scanner.unread();
                int b = scanner.read();
                scanner.read();
                if (b == 60) {
                    return Token.UNDEFINED;
                }
            }
            if ((term = RubySyntaxUtils.getPercentStringTerminator((char)(leader = this.startSequenceDetected(scanner)))) != '\u0000' && this.endSequenceDetected(scanner, leader, term)) {
                return this.fToken;
            }
        }
        scanner.unread();
        return Token.UNDEFINED;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        return this.evaluate(scanner, false);
    }

    /*
     * Unable to fully structure code
     */
    protected boolean endSequenceDetected(ICharacterScanner scanner, char lead, char term) {
        block13: {
            originalDelimiters = scanner.getLegalLineDelimiters();
            count = originalDelimiters.length;
            if (this.fLineDelimiters != null && originalDelimiters.length == count) ** GOTO lbl7
            this.fSortedLineDelimiters = new char[count][];
            break block13;
lbl-1000:
            // 1 sources

            {
                --count;
lbl7:
                // 2 sources

                ** while (count > 0 && this.fLineDelimiters[count - 1] == originalDelimiters[count - 1])
            }
        }
        if (count != 0) {
            this.fLineDelimiters = originalDelimiters;
            System.arraycopy(this.fLineDelimiters, 0, this.fSortedLineDelimiters, 0, this.fLineDelimiters.length);
            Arrays.sort(this.fSortedLineDelimiters, this.fLineDelimiterComparator);
        }
        nestCount = 1;
        d = 0;
        block1: while ((c = scanner.read()) != -1) {
            ++d;
            if (c == 92) {
                if (this.fEscapeContinuesLine) {
                    c = scanner.read();
                    i = 0;
                    while (i < this.fSortedLineDelimiters.length) {
                        if (c == this.fSortedLineDelimiters[i][0] && this.sequenceDetected(scanner, this.fSortedLineDelimiters[i], true)) continue block1;
                        ++i;
                    }
                    continue;
                }
                scanner.read();
                continue;
            }
            if (lead != term && c == lead) {
                ++nestCount;
                continue;
            }
            if (c == term) {
                if (--nestCount > 0) continue;
                return true;
            }
            if (c == 37) {
                while (d-- > 0) {
                    scanner.unread();
                }
                return false;
            }
            if (!this.fBreaksOnEOL) continue;
            i = 0;
            while (i < this.fSortedLineDelimiters.length) {
                if (c == this.fSortedLineDelimiters[i][0] && this.sequenceDetected(scanner, this.fSortedLineDelimiters[i], true)) {
                    return true;
                }
                ++i;
            }
        }
        if (this.fBreaksOnEOF) {
            return true;
        }
        scanner.unread();
        return false;
    }

    protected char startSequenceDetected(ICharacterScanner scanner) {
        char term;
        int c = scanner.read();
        if (c == -1) {
            scanner.unread();
            return '\u0000';
        }
        boolean letterFound = false;
        if (RubySyntaxUtils.isValidPercentStringStarter((char)((char)c))) {
            letterFound = true;
            c = scanner.read();
            if (c == -1) {
                scanner.unread();
                scanner.unread();
                return '\u0000';
            }
        }
        if ((term = RubySyntaxUtils.getPercentStringTerminator((char)((char)c))) == '\u0000') {
            scanner.unread();
            if (letterFound) {
                scanner.unread();
            }
            return '\u0000';
        }
        return (char)c;
    }

    protected boolean sequenceDetected(ICharacterScanner scanner, char[] sequence, boolean eofAllowed) {
        int i = 1;
        while (i < sequence.length) {
            int c = scanner.read();
            if (c == -1 && eofAllowed) {
                return true;
            }
            if (c != sequence[i]) {
                scanner.unread();
                int j = i - 1;
                while (j > 0) {
                    scanner.unread();
                    --j;
                }
                return false;
            }
            ++i;
        }
        return true;
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        int c = scanner.read();
        scanner.unread();
        if (c == 37) {
            return this.doEvaluate(scanner, resume);
        }
        return Token.UNDEFINED;
    }

    public IToken getSuccessToken() {
        return this.fToken;
    }

    private static class DecreasingCharArrayLengthComparator
    implements Comparator<char[]> {
        private DecreasingCharArrayLengthComparator() {
        }

        @Override
        public int compare(char[] o1, char[] o2) {
            return o2.length - o1.length;
        }
    }
}

