/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.routineeditor.commonui;

import java.util.regex.Matcher;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.model.validation.SybaseParameterValidator;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.routineeditor.commonui.ParametersRowData;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.utils.SQLUtil;
import org.eclipse.datatools.enablement.sybase.models.sybasesqlmodel.SybaseParameter;
import org.eclipse.datatools.modelbase.sql.datatypes.CharacterStringDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DateDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DistinctUserDefinedType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.TimeDataType;
import org.eclipse.datatools.sqltools.common.ui.tableviewer.AccessibleTableViewer;
import org.eclipse.datatools.sqltools.common.ui.tableviewer.TableDataCellModifier;
import org.eclipse.swt.widgets.TableItem;

public class ParameterDataCellModifier
extends TableDataCellModifier {
    private boolean _enforcePrefix = false;
    private boolean _supportsExp = false;

    public ParameterDataCellModifier(AccessibleTableViewer viewer, boolean enforcePrefix, boolean supportsExp) {
        super(viewer);
        this._enforcePrefix = enforcePrefix;
        this._supportsExp = supportsExp;
    }

    public void modify(Object element, String property, Object value) {
        DataType type;
        SybaseParameter p;
        Object obj;
        int column = this.getColumnIndex(property);
        if (column == 1) {
            if (this._enforcePrefix && value != null && !((String)value).trim().equals("") && !((String)value).startsWith("@")) {
                value = "@" + value.toString();
            }
        } else if (column == 4 && value != null && element instanceof TableItem && (obj = ((TableItem)element).getData()) != null && obj instanceof ParametersRowData && (p = ((ParametersRowData)((Object)obj)).getParameter()) != null && this.isStringDataType(type = p.getDataType())) {
            String unquote = SQLUtil.unquote((String)value);
            Matcher m = SybaseParameterValidator.NON_WORD.matcher((String)value);
            if (m.find() && value.equals(unquote) && !this._supportsExp) {
                value = SQLUtil.quote((String)value, '\'');
            }
        }
        super.modify(element, property, value);
    }

    private boolean isStringDataType(DataType type) {
        if (type instanceof PredefinedDataType) {
            return type instanceof CharacterStringDataType || type instanceof DateDataType || type instanceof TimeDataType;
        }
        if (type instanceof DistinctUserDefinedType) {
            return this.isStringDataType((DataType)((DistinctUserDefinedType)type).getPredefinedRepresentation());
        }
        return false;
    }
}

