/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.filter.model;

import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.filter.model.ITmfFilterTreeNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterRootNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterTreeNode;

public class TmfFilterAndNode
extends TmfFilterTreeNode {
    public static final String NODE_NAME = "AND";
    public static final String NOT_ATTR = "not";
    private boolean fNot = false;

    public TmfFilterAndNode(ITmfFilterTreeNode parent) {
        super(parent);
    }

    public boolean isNot() {
        return this.fNot;
    }

    public void setNot(boolean not) {
        this.fNot = not;
    }

    @Override
    public String getNodeName() {
        return NODE_NAME;
    }

    @Override
    public boolean matches(ITmfEvent event) {
        if (this.getChildren().length == 0) {
            return this.fNot;
        }
        ITmfFilterTreeNode[] iTmfFilterTreeNodeArray = this.getChildren();
        int n = iTmfFilterTreeNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITmfFilterTreeNode node = iTmfFilterTreeNodeArray[n2];
            if (!node.matches(event)) {
                return this.fNot;
            }
            ++n2;
        }
        return true ^ this.fNot;
    }

    @Override
    public String toString(boolean explicit) {
        StringBuffer buf = new StringBuffer();
        if (this.fNot) {
            buf.append("not ");
        }
        if (this.getParent() != null && !(this.getParent() instanceof TmfFilterRootNode) && !(this.getParent() instanceof TmfFilterNode)) {
            buf.append("( ");
        }
        int i = 0;
        while (i < this.getChildrenCount()) {
            ITmfFilterTreeNode node = this.getChildren()[i];
            buf.append(node.toString(explicit));
            if (i < this.getChildrenCount() - 1) {
                buf.append(" and ");
            }
            ++i;
        }
        if (this.getParent() != null && !(this.getParent() instanceof TmfFilterRootNode) && !(this.getParent() instanceof TmfFilterNode)) {
            buf.append(" )");
        }
        return buf.toString();
    }
}

