/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.readwrite;

import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlActionCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlConditionCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlStateValueCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenAction;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenCondition;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValue;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlModelFactory;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlPatternEventHandler;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.IXmlStateSystemContainer;
import org.w3c.dom.Element;

public class TmfXmlReadWriteModelFactory
implements ITmfXmlModelFactory {
    private static @Nullable ITmfXmlModelFactory fInstance = null;

    public static synchronized ITmfXmlModelFactory getInstance() {
        ITmfXmlModelFactory instance = fInstance;
        if (instance == null) {
            fInstance = instance = new TmfXmlReadWriteModelFactory();
        }
        return instance;
    }

    @Override
    public DataDrivenValue createStateValue(Element node, IXmlStateSystemContainer container) {
        TmfXmlStateValueCu compile = Objects.requireNonNull(TmfXmlStateValueCu.compileValue(container.getAnalysisCompilationData(), node), "State value did not compile correctly");
        return compile.generate();
    }

    @Override
    public DataDrivenCondition createCondition(Element node, IXmlStateSystemContainer container) {
        TmfXmlConditionCu compile = Objects.requireNonNull(TmfXmlConditionCu.compile(container.getAnalysisCompilationData(), node), "Condition did not compile correctly");
        return compile.generate();
    }

    @Override
    public DataDrivenAction createStateChange(Element node, IXmlStateSystemContainer container) {
        TmfXmlActionCu compile = Objects.requireNonNull(TmfXmlActionCu.compile(container.getAnalysisCompilationData(), node), "State change did not compile correctly");
        return compile.generate();
    }

    @Override
    public TmfXmlPatternEventHandler createPatternEventHandler(Element node, IXmlStateSystemContainer container) {
        return new TmfXmlPatternEventHandler(this, node, container);
    }

    @Override
    public String createTransitionValidator(Element node, IXmlStateSystemContainer container) {
        return Objects.requireNonNull(TmfXmlConditionCu.compileNamedCondition(container.getAnalysisCompilationData(), node), "Named condition did not compile correctly");
    }

    @Override
    public String createAction(Element node, IXmlStateSystemContainer container) {
        return Objects.requireNonNull(TmfXmlActionCu.compileNamedAction(container.getAnalysisCompilationData(), node), "Named action did not compile correctly");
    }
}

