/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model;

import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenFsm;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenFsmState;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.module.IAnalysisDataContainer;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlScenarioHistoryBuilder;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlScenarioInfo;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.IXmlStateSystemContainer;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.pattern.stateprovider.XmlPatternStateProvider;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;

public class TmfXmlScenario {
    private final IXmlStateSystemContainer fContainer;
    private final DataDrivenFsm fFsm;
    private TmfXmlScenarioInfo fScenarioInfo;
    TmfXmlScenarioHistoryBuilder fHistoryBuilder;

    public TmfXmlScenario(ITmfEvent event, DataDrivenFsm fsm, DataDrivenFsmState initialState, IXmlStateSystemContainer container) {
        this.fFsm = fsm;
        this.fContainer = container;
        this.fHistoryBuilder = ((XmlPatternStateProvider)container).getHistoryBuilder();
        int quark = this.fHistoryBuilder.assignScenarioQuark(this.fContainer, fsm);
        int statusQuark = this.fHistoryBuilder.getScenarioStatusQuark(this.fContainer, quark);
        this.fScenarioInfo = new TmfXmlScenarioInfo(initialState, TmfXmlScenarioHistoryBuilder.ScenarioStatusType.PENDING, quark, statusQuark, this.fFsm);
        this.fHistoryBuilder.update(this.fContainer, this.fScenarioInfo, event);
    }

    public TmfXmlScenarioInfo getScenarioInfos() {
        return this.fScenarioInfo;
    }

    public void cancel() {
        this.fScenarioInfo.setStatus(TmfXmlScenarioHistoryBuilder.ScenarioStatusType.ABANDONED);
        if (this.fScenarioInfo.getStatus() != TmfXmlScenarioHistoryBuilder.ScenarioStatusType.PENDING) {
            this.fHistoryBuilder.completeScenario(this.fContainer, this.fScenarioInfo, null);
        }
    }

    public boolean isActive() {
        return this.fScenarioInfo.getStatus() == TmfXmlScenarioHistoryBuilder.ScenarioStatusType.IN_PROGRESS;
    }

    public boolean isPending() {
        return this.fScenarioInfo.getStatus() == TmfXmlScenarioHistoryBuilder.ScenarioStatusType.PENDING;
    }

    public boolean handleEvent(ITmfEvent event, IAnalysisDataContainer container) {
        DataDrivenFsmState activeState = this.fScenarioInfo.getActiveState();
        DataDrivenFsmState nextState = activeState.takeTransition(event, this.fScenarioInfo, container);
        if (nextState == null) {
            return false;
        }
        if (this.fScenarioInfo.getStatus().equals((Object)TmfXmlScenarioHistoryBuilder.ScenarioStatusType.PENDING)) {
            this.fScenarioInfo.setStatus(TmfXmlScenarioHistoryBuilder.ScenarioStatusType.IN_PROGRESS);
            this.fHistoryBuilder.startScenario(this.fContainer, this.fScenarioInfo, event);
        }
        if (nextState.isFinal()) {
            this.fScenarioInfo.setStatus(TmfXmlScenarioHistoryBuilder.ScenarioStatusType.MATCHED);
            this.fHistoryBuilder.completeScenario(this.fContainer, this.fScenarioInfo, event);
        }
        this.fScenarioInfo.setActiveState(nextState);
        this.fHistoryBuilder.update(this.fContainer, this.fScenarioInfo, event);
        return true;
    }
}

