/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values;

import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenScenarioInfo;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenStateSystemPath;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValue;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.module.DataDrivenException;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.module.IAnalysisDataContainer;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;

public class DataDrivenValueStackPeek
extends DataDrivenValue {
    private final DataDrivenStateSystemPath fPath;

    public DataDrivenValueStackPeek(@Nullable String mappingGroupId, ITmfStateValue.Type forcedType, DataDrivenStateSystemPath path) {
        super(mappingGroupId, forcedType);
        this.fPath = path;
    }

    @Override
    protected @Nullable Object resolveValue(int baseQuark, IAnalysisDataContainer container) {
        return null;
    }

    @Override
    protected @Nullable Object resolveValue(ITmfEvent event, int baseQuark, DataDrivenScenarioInfo scenarioInfo, IAnalysisDataContainer container) {
        long ts = event.getTimestamp().toNanos();
        Object value = null;
        ITmfStateSystem ss = container.getStateSystem();
        int quarkQuery = this.fPath.getQuark(event, baseQuark, scenarioInfo, container);
        if (quarkQuery >= 0) {
            try {
                @Nullable ITmfStateInterval stackTopInterval = StateSystemUtils.querySingleStackTop((ITmfStateSystem)ss, (long)ts, (int)quarkQuery);
                return stackTopInterval != null ? stackTopInterval.getStateValue().unboxValue() : null;
            }
            catch (AttributeNotFoundException | StateSystemDisposedException e) {
                throw new DataDrivenException("Resolving stack peek: " + e.getMessage(), event);
            }
        }
        return value;
    }

    @Override
    public String toString() {
        return "DataDrivenValueStackPeek";
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.fPath);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof DataDrivenValueStackPeek)) {
            return false;
        }
        DataDrivenValueStackPeek other = (DataDrivenValueStackPeek)obj;
        return Objects.equals(this.fPath, other.fPath);
    }
}

