/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.profile.core.engine;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.profile.core.PHPProfileCoreMessages;
import org.eclipse.php.profile.core.data.ProfilerData;
import org.eclipse.php.profile.core.engine.DefaultProfilerDB;
import org.eclipse.php.profile.core.engine.ProfileSessionsManager;
import org.eclipse.php.profile.core.engine.cachegrind.CacheGrindModelParser;

public class PHPLaunchListener
implements ILaunchListener {
    public void launchRemoved(ILaunch launch) {
    }

    public void launchAdded(ILaunch launch) {
    }

    public void launchChanged(final ILaunch launch) {
        if (launch.getLaunchMode().equals("profile") && launch.getAttribute("org.eclipse.php.debug.core.CacheGrind_File") != null) {
            new Job(String.valueOf(PHPProfileCoreMessages.PHPLaunchListener_0) + launch.getLaunchConfiguration().getName()){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected IStatus run(IProgressMonitor monitor) {
                    SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
                    sub.beginTask(PHPProfileCoreMessages.PHPLaunchListener_1, 2);
                    sub.setBlocked((IStatus)new Status(0, "org.eclipse.php.profile.core", PHPProfileCoreMessages.PHPLaunchListener_2));
                    while (!monitor.isCanceled() && !launch.isTerminated()) {
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException interruptedException) {
                            return Status.CANCEL_STATUS;
                        }
                    }
                    sub.clearBlocked();
                    sub.worked(1);
                    sub.beginTask(PHPProfileCoreMessages.PHPLaunchListener_3, 1);
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    File f = new File(launch.getAttribute("org.eclipse.php.debug.core.CacheGrind_File"));
                    if (!f.exists()) return new Status(4, "org.eclipse.php.profile.core", PHPProfileCoreMessages.PHPLaunchListener_7);
                    if (f.length() <= 0L) return new Status(4, "org.eclipse.php.profile.core", PHPProfileCoreMessages.PHPLaunchListener_6);
                    try {
                        CacheGrindModelParser tmp = new CacheGrindModelParser(new FileInputStream(f));
                        ProfilerData[] models = tmp.buildModel();
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        ProfilerData[] profilerDataArray = models;
                        int n = models.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ProfilerData model = profilerDataArray[n2];
                            ProfileSessionsManager.addSession(new DefaultProfilerDB(model, new Date()));
                            ++n2;
                        }
                        f.delete();
                        if (models.length != 0) return Status.OK_STATUS;
                        return new Status(4, "org.eclipse.php.profile.core", PHPProfileCoreMessages.PHPLaunchListener_4);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        return Status.OK_STATUS;
                    }
                    catch (IOException e) {
                        return new Status(4, "org.eclipse.php.profile.core", NLS.bind((String)PHPProfileCoreMessages.PHPLaunchListener_5, (Object)e.getMessage()));
                    }
                }
            }.schedule();
        }
    }
}

