/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.functions;

import org.eclipse.jubula.client.core.functions.AbstractFunctionEvaluator;
import org.eclipse.jubula.tools.internal.exception.InvalidDataException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;

public class FormatNumberEvaluator
extends AbstractFunctionEvaluator {
    public String evaluate(String[] arguments) throws InvalidDataException {
        this.validateParamCount(arguments, 2);
        try {
            Double number = Double.parseDouble(arguments[0]);
            Integer decimals = Integer.parseInt(arguments[1]);
            if (decimals == 0) {
                return String.format("%.0f", Math.floor(number));
            }
            if (decimals > 0) {
                double formatted = (double)((long)(number * Math.pow(10.0, decimals.intValue()))) / Math.pow(10.0, decimals.intValue());
                return Double.toString(formatted);
            }
            throw new InvalidDataException("Invalid decimals parameter: " + arguments[1], MessageIDs.E_NEG_VAL);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidDataException("Invalid parameter(s) for formatNumber function", MessageIDs.E_PARAMETER_ERROR);
        }
    }
}

