/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.pattern.id;

import org.eclipse.emf.common.util.EList;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IDirectEditingContext;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.LayoutContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.Property;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.pattern.IPattern;
import org.eclipse.graphiti.pattern.TypedPattern;
import org.eclipse.graphiti.pattern.config.IPatternConfiguration;
import org.eclipse.graphiti.pattern.id.IdLayoutContext;
import org.eclipse.graphiti.pattern.id.IdUpdateContext;
import org.eclipse.graphiti.services.Graphiti;

public abstract class IdPattern
extends TypedPattern
implements IPattern {
    protected static final String PROPERTY_VALUE_PATTERN_TYPE_ID = "org.eclipse.graphiti.pattern.idpattern";
    protected static final String PROPERTY_KEY_ID = "org.eclipse.graphiti.pattern.id.id";
    protected static final String PROPERTY_KEY_INDEX = "org.eclipse.graphiti.pattern.id.index";

    public IdPattern() {
    }

    public IdPattern(IPatternConfiguration patternConfiguration) {
        super(patternConfiguration);
    }

    @Override
    protected boolean isPatternControlled(PictogramElement pictogramElement) {
        Object domainObject = this.getBusinessObjectForPictogramElement(pictogramElement);
        return this.isMainBusinessObjectApplicable(domainObject);
    }

    @Override
    protected boolean isPatternRoot(PictogramElement pictogramElement) {
        Object domainObject = this.getBusinessObjectForPictogramElement(pictogramElement);
        if (!this.isMainBusinessObjectApplicable(domainObject)) {
            return false;
        }
        String patternTypePropertyValue = Graphiti.getPeService().getPropertyValue((PropertyContainer)pictogramElement, "org.eclipse.graphiti.pattern.patternType");
        return PROPERTY_VALUE_PATTERN_TYPE_ID.equals(patternTypePropertyValue);
    }

    protected void setId(PropertyContainer container, String id) {
        Graphiti.getPeService().setPropertyValue(container, PROPERTY_KEY_ID, id);
    }

    protected String getId(PropertyContainer container) {
        EList properties = container.getProperties();
        for (Property property : properties) {
            if (!PROPERTY_KEY_ID.equals(property.getKey())) continue;
            return property.getValue();
        }
        return null;
    }

    protected PropertyContainer findById(PictogramElement pictogramElement, String idToFind) {
        PropertyContainer propertyContainer;
        if (idToFind == null || idToFind.length() == 0) {
            return null;
        }
        String id = this.getId((PropertyContainer)pictogramElement);
        if (idToFind.equals(id)) {
            return pictogramElement;
        }
        GraphicsAlgorithm graphicsAlgorithm = pictogramElement.getGraphicsAlgorithm();
        id = this.getId((PropertyContainer)graphicsAlgorithm);
        if (idToFind.equals(id)) {
            return graphicsAlgorithm;
        }
        if (pictogramElement instanceof ContainerShape) {
            EList children = ((ContainerShape)pictogramElement).getChildren();
            for (Shape shape : children) {
                PropertyContainer propertyContainer2 = this.findById((PictogramElement)shape, idToFind);
                if (propertyContainer2 == null) continue;
                return propertyContainer2;
            }
        }
        if ((propertyContainer = this.findByIdInGraphicsAlgorithmChildren(graphicsAlgorithm, idToFind)) != null) {
            return propertyContainer;
        }
        return null;
    }

    private PropertyContainer findByIdInGraphicsAlgorithmChildren(GraphicsAlgorithm graphicsAlgorithm, String idToFind) {
        EList graphicsAlgorithmChildren = graphicsAlgorithm.getGraphicsAlgorithmChildren();
        for (GraphicsAlgorithm graphicsAlgorithmChild : graphicsAlgorithmChildren) {
            String id = this.getId((PropertyContainer)graphicsAlgorithmChild);
            if (idToFind.equals(id)) {
                return graphicsAlgorithmChild;
            }
            PropertyContainer propertyContainer = this.findByIdInGraphicsAlgorithmChildren(graphicsAlgorithmChild, idToFind);
            if (propertyContainer == null) continue;
            return propertyContainer;
        }
        return null;
    }

    protected void setIndex(PropertyContainer container, int index) {
        Graphiti.getPeService().setPropertyValue(container, PROPERTY_KEY_INDEX, Integer.toString(index));
    }

    protected int getIndex(PropertyContainer container) {
        EList properties = container.getProperties();
        for (Property property : properties) {
            if (!PROPERTY_KEY_INDEX.equals(property.getKey())) continue;
            return Integer.valueOf(property.getValue());
        }
        return -1;
    }

    @Override
    public boolean canAdd(IAddContext context) {
        return this.isMainBusinessObjectApplicable(context.getNewObject());
    }

    @Override
    public PictogramElement add(IAddContext context) {
        PictogramElement pictogramElement = this.doAdd(context);
        this.setPatternType((PropertyContainer)pictogramElement, PROPERTY_VALUE_PATTERN_TYPE_ID);
        this.update((IUpdateContext)new UpdateContext(pictogramElement));
        this.layout((ILayoutContext)new LayoutContext(pictogramElement));
        return pictogramElement;
    }

    protected abstract PictogramElement doAdd(IAddContext var1);

    @Override
    public boolean canLayout(ILayoutContext context) {
        return PROPERTY_VALUE_PATTERN_TYPE_ID.equals(this.getPatternType((PropertyContainer)context.getPictogramElement())) && this.isMainBusinessObjectApplicable(this.getBusinessObjectForPictogramElement(context.getPictogramElement()));
    }

    @Override
    public boolean layout(ILayoutContext context) {
        IdLayoutContext layoutContext;
        GraphicsAlgorithm graphicsAlgorithm;
        IdLayoutContext layoutContext2;
        PictogramElement pictogramElement;
        PictogramElement rootPictogramElement;
        boolean changesDone = false;
        if (context instanceof IdLayoutContext) {
            rootPictogramElement = ((IdLayoutContext)context).getRootPictogramElement();
        } else {
            rootPictogramElement = context.getPictogramElement();
            while (!this.isPatternRoot(rootPictogramElement)) {
                if (rootPictogramElement instanceof Shape) {
                    ContainerShape container = ((Shape)rootPictogramElement).getContainer();
                    if (container == null) break;
                    rootPictogramElement = container;
                    continue;
                }
                if (!(rootPictogramElement instanceof GraphicsAlgorithm)) continue;
                pictogramElement = ((GraphicsAlgorithm)rootPictogramElement).getPictogramElement();
                if (pictogramElement == null) break;
                rootPictogramElement = pictogramElement;
            }
        }
        pictogramElement = context.getPictogramElement();
        String id = this.getId((PropertyContainer)pictogramElement);
        if (id != null && this.layout(layoutContext2 = new IdLayoutContext(pictogramElement, pictogramElement.getGraphicsAlgorithm(), rootPictogramElement), id)) {
            changesDone = true;
        }
        if ((id = this.getId((PropertyContainer)(graphicsAlgorithm = pictogramElement.getGraphicsAlgorithm()))) != null && this.layout(layoutContext = new IdLayoutContext(graphicsAlgorithm.getPictogramElement(), graphicsAlgorithm, rootPictogramElement), id)) {
            changesDone = true;
        }
        if (pictogramElement instanceof ContainerShape) {
            EList children = ((ContainerShape)pictogramElement).getChildren();
            for (Shape shape : children) {
                IdLayoutContext idContext = new IdLayoutContext((PictogramElement)shape, shape.getGraphicsAlgorithm(), rootPictogramElement);
                if (!this.layout((ILayoutContext)idContext)) continue;
                changesDone = true;
            }
        }
        if (this.layoutGraphicsAlgorithmChildren(graphicsAlgorithm, layoutContext = context instanceof IdLayoutContext ? (IdLayoutContext)context : new IdLayoutContext(null, graphicsAlgorithm, rootPictogramElement))) {
            changesDone = true;
        }
        return changesDone;
    }

    protected boolean layoutGraphicsAlgorithmChildren(GraphicsAlgorithm graphicsAlgorithm, IdLayoutContext context) {
        boolean changesDone = false;
        EList graphicsAlgorithmChildren = graphicsAlgorithm.getGraphicsAlgorithmChildren();
        for (GraphicsAlgorithm graphicsAlgorithmChild : graphicsAlgorithmChildren) {
            IdLayoutContext layoutContext;
            String id = this.getId((PropertyContainer)graphicsAlgorithmChild);
            if (id != null && this.layout(layoutContext = new IdLayoutContext(graphicsAlgorithmChild.getPictogramElement(), graphicsAlgorithmChild, context.getRootPictogramElement()), id)) {
                changesDone = true;
            }
            if (!this.layoutGraphicsAlgorithmChildren(graphicsAlgorithmChild, context)) continue;
            changesDone = true;
        }
        return changesDone;
    }

    protected abstract boolean layout(IdLayoutContext var1, String var2);

    @Override
    public boolean canUpdate(IUpdateContext context) {
        return PROPERTY_VALUE_PATTERN_TYPE_ID.equals(this.getPatternType((PropertyContainer)context.getPictogramElement())) && this.isMainBusinessObjectApplicable(this.getBusinessObjectForPictogramElement(context.getPictogramElement()));
    }

    @Override
    public IReason updateNeeded(IUpdateContext context) {
        IdUpdateContext updateContext;
        IReason reason;
        PictogramElement element;
        IdUpdateContext updateContext2;
        IReason reason2;
        IdUpdateContext updateContext3;
        IReason reason3;
        PictogramElement rootPictogramElement = context instanceof IdUpdateContext ? ((IdUpdateContext)context).getRootPictogramElement() : context.getPictogramElement();
        PictogramElement pictogramElement = context.getPictogramElement();
        String id = this.getId((PropertyContainer)pictogramElement);
        if (id != null && (reason3 = this.updateNeeded(updateContext3 = new IdUpdateContext(pictogramElement, pictogramElement.getGraphicsAlgorithm(), rootPictogramElement, this.getBusinessObjectForPictogramElement(pictogramElement)), id)).toBoolean()) {
            return reason3;
        }
        GraphicsAlgorithm graphicsAlgorithm = pictogramElement.getGraphicsAlgorithm();
        id = this.getId((PropertyContainer)graphicsAlgorithm);
        if (id != null && (reason2 = this.updateNeeded(updateContext2 = new IdUpdateContext(element = graphicsAlgorithm.getPictogramElement(), graphicsAlgorithm, rootPictogramElement, this.getBusinessObjectForPictogramElement(element)), id)).toBoolean()) {
            return reason2;
        }
        if (pictogramElement instanceof ContainerShape) {
            EList children = ((ContainerShape)pictogramElement).getChildren();
            for (Shape shape : children) {
                IdUpdateContext updateContext4 = new IdUpdateContext((PictogramElement)shape, shape.getGraphicsAlgorithm(), rootPictogramElement, this.getBusinessObjectForPictogramElement((PictogramElement)shape));
                IReason reason4 = this.updateNeeded((IUpdateContext)updateContext4);
                if (!reason4.toBoolean()) continue;
                return reason4;
            }
        }
        if ((reason = this.updateNeededGraphicsAlgorithmChildren(graphicsAlgorithm, updateContext = context instanceof IdUpdateContext ? (IdUpdateContext)context : new IdUpdateContext(null, graphicsAlgorithm, rootPictogramElement, null))).toBoolean()) {
            return reason;
        }
        return Reason.createFalseReason();
    }

    protected IReason updateNeededGraphicsAlgorithmChildren(GraphicsAlgorithm graphicsAlgorithm, IdUpdateContext context) {
        EList graphicsAlgorithmChildren = graphicsAlgorithm.getGraphicsAlgorithmChildren();
        for (GraphicsAlgorithm graphicsAlgorithmChild : graphicsAlgorithmChildren) {
            PictogramElement pictogramElement;
            IdUpdateContext updateContext;
            IReason reason;
            String id = this.getId((PropertyContainer)graphicsAlgorithmChild);
            if (id != null && (reason = this.updateNeeded(updateContext = new IdUpdateContext(pictogramElement = graphicsAlgorithmChild.getPictogramElement(), graphicsAlgorithmChild, context.getRootPictogramElement(), this.getBusinessObjectForPictogramElement(pictogramElement)), id)).toBoolean()) {
                return reason;
            }
            IReason reason2 = this.updateNeededGraphicsAlgorithmChildren(graphicsAlgorithmChild, context);
            if (!reason2.toBoolean()) continue;
            return reason2;
        }
        return Reason.createFalseReason();
    }

    protected abstract IReason updateNeeded(IdUpdateContext var1, String var2);

    @Override
    public boolean update(IUpdateContext context) {
        return this.update(context, false);
    }

    protected boolean update(IUpdateContext context, boolean innerCall) {
        IdUpdateContext updateContext;
        PictogramElement element;
        IdUpdateContext updateContext2;
        GraphicsAlgorithm graphicsAlgorithm;
        IdUpdateContext updateContext3;
        boolean result = false;
        PictogramElement rootPictogramElement = context instanceof IdUpdateContext ? ((IdUpdateContext)context).getRootPictogramElement() : context.getPictogramElement();
        PictogramElement pictogramElement = context.getPictogramElement();
        String id = this.getId((PropertyContainer)pictogramElement);
        if (id != null && this.update(updateContext3 = new IdUpdateContext(pictogramElement, pictogramElement.getGraphicsAlgorithm(), rootPictogramElement, this.getBusinessObjectForPictogramElement(pictogramElement)), id)) {
            result = true;
        }
        if ((id = this.getId((PropertyContainer)(graphicsAlgorithm = pictogramElement.getGraphicsAlgorithm()))) != null && this.update(updateContext2 = new IdUpdateContext(element = graphicsAlgorithm.getPictogramElement(), graphicsAlgorithm, rootPictogramElement, this.getBusinessObjectForPictogramElement(element)), id)) {
            result = true;
        }
        if (pictogramElement instanceof ContainerShape) {
            EList children = ((ContainerShape)pictogramElement).getChildren();
            for (Shape shape : children) {
                IdUpdateContext updateContext4 = new IdUpdateContext((PictogramElement)shape, shape.getGraphicsAlgorithm(), rootPictogramElement, this.getBusinessObjectForPictogramElement((PictogramElement)shape));
                if (!this.update((IUpdateContext)updateContext4, true)) continue;
                result = true;
            }
        }
        if (this.updateGraphicsAlgorithmChildren(graphicsAlgorithm, updateContext = context instanceof IdUpdateContext ? (IdUpdateContext)context : new IdUpdateContext(null, graphicsAlgorithm, rootPictogramElement, null))) {
            result = true;
        }
        if (result && !innerCall) {
            this.layoutPictogramElement(rootPictogramElement);
        }
        return result;
    }

    protected boolean updateGraphicsAlgorithmChildren(GraphicsAlgorithm graphicsAlgorithm, IdUpdateContext context) {
        boolean result = false;
        EList graphicsAlgorithmChildren = graphicsAlgorithm.getGraphicsAlgorithmChildren();
        for (GraphicsAlgorithm graphicsAlgorithmChild : graphicsAlgorithmChildren) {
            PictogramElement pictogramElement;
            IdUpdateContext updateContext;
            String id = this.getId((PropertyContainer)graphicsAlgorithmChild);
            if (id != null && this.update(updateContext = new IdUpdateContext(pictogramElement = graphicsAlgorithmChild.getPictogramElement(), graphicsAlgorithmChild, context.getRootPictogramElement(), this.getBusinessObjectForPictogramElement(pictogramElement)), id)) {
                result = true;
            }
            if (!this.updateGraphicsAlgorithmChildren(graphicsAlgorithmChild, context)) continue;
            result = true;
        }
        return result;
    }

    protected abstract boolean update(IdUpdateContext var1, String var2);

    @Override
    public int getEditingType() {
        return super.getEditingType();
    }

    @Override
    public boolean canDirectEdit(IDirectEditingContext context) {
        boolean patternResponsible;
        PictogramElement pictogramElement = context.getPictogramElement();
        Object domainObject = this.getBusinessObjectForPictogramElement(pictogramElement);
        boolean bl = patternResponsible = PROPERTY_VALUE_PATTERN_TYPE_ID.equals(this.getPatternType((PropertyContainer)pictogramElement)) && this.isMainBusinessObjectApplicable(domainObject);
        if (patternResponsible) {
            String id = this.getId((PropertyContainer)pictogramElement);
            if (id == null) {
                id = this.getId((PropertyContainer)context.getGraphicsAlgorithm());
            }
            if (id != null) {
                return this.canDirectEdit(context, id);
            }
        }
        return false;
    }

    protected boolean canDirectEdit(IDirectEditingContext context, String id) {
        return false;
    }

    @Override
    public String getInitialValue(IDirectEditingContext context) {
        boolean patternResponsible;
        PictogramElement pictogramElement = context.getPictogramElement();
        Object domainObject = this.getBusinessObjectForPictogramElement(pictogramElement);
        boolean bl = patternResponsible = PROPERTY_VALUE_PATTERN_TYPE_ID.equals(this.getPatternType((PropertyContainer)pictogramElement)) && this.isMainBusinessObjectApplicable(domainObject);
        if (patternResponsible) {
            String id = this.getId((PropertyContainer)pictogramElement);
            if (id == null) {
                id = this.getId((PropertyContainer)context.getGraphicsAlgorithm());
            }
            if (id != null) {
                return this.getInitialValue(context, id);
            }
        }
        return "";
    }

    protected String getInitialValue(IDirectEditingContext context, String id) {
        return "";
    }

    @Override
    public String checkValueValid(String value, IDirectEditingContext context) {
        boolean patternResponsible;
        PictogramElement pictogramElement = context.getPictogramElement();
        Object domainObject = this.getBusinessObjectForPictogramElement(pictogramElement);
        boolean bl = patternResponsible = PROPERTY_VALUE_PATTERN_TYPE_ID.equals(this.getPatternType((PropertyContainer)pictogramElement)) && this.isMainBusinessObjectApplicable(domainObject);
        if (patternResponsible) {
            String id = this.getId((PropertyContainer)pictogramElement);
            if (id == null) {
                id = this.getId((PropertyContainer)context.getGraphicsAlgorithm());
            }
            if (id != null) {
                return this.checkValueValid(value, context, id);
            }
        }
        return null;
    }

    protected String checkValueValid(String value, IDirectEditingContext context, String id) {
        return null;
    }

    @Override
    public void setValue(String value, IDirectEditingContext context) {
        boolean patternResponsible;
        PictogramElement pictogramElement = context.getPictogramElement();
        Object domainObject = this.getBusinessObjectForPictogramElement(pictogramElement);
        boolean bl = patternResponsible = PROPERTY_VALUE_PATTERN_TYPE_ID.equals(this.getPatternType((PropertyContainer)pictogramElement)) && this.isMainBusinessObjectApplicable(domainObject);
        if (patternResponsible) {
            String id = this.getId((PropertyContainer)pictogramElement);
            if (id == null) {
                id = this.getId((PropertyContainer)context.getGraphicsAlgorithm());
            }
            if (id != null) {
                this.setValue(value, context, id);
            }
        }
    }

    protected void setValue(String value, IDirectEditingContext context, String id) {
    }
}

