/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import org.jruby.ast.Node;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.MethodIndex;

public class OpElementAsgnNode
extends Node {
    static final long serialVersionUID = 1509701560452403776L;
    private final Node receiverNode;
    private String operatorName;
    private final Node argsNode;
    private final Node valueNode;
    public final int index;

    public OpElementAsgnNode(ISourcePosition position, Node receiverNode, String operatorName, Node argsNode, Node valueNode) {
        super(position, 68);
        this.receiverNode = receiverNode;
        this.operatorName = operatorName.intern();
        this.argsNode = argsNode;
        this.valueNode = valueNode;
        this.index = MethodIndex.getIndex(this.operatorName);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.operatorName = this.operatorName.intern();
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitOpElementAsgnNode(this);
    }

    public Node getArgsNode() {
        return this.argsNode;
    }

    public String getOperatorName() {
        return this.operatorName;
    }

    public Node getReceiverNode() {
        return this.receiverNode;
    }

    public Node getValueNode() {
        return this.valueNode;
    }

    @Override
    public List childNodes() {
        return Node.createList(this.receiverNode, this.argsNode, this.valueNode);
    }
}

