/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.debug.ui.console;

import org.eclipse.dltk.ruby.internal.debug.ui.console.RubyFileHyperlink;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.IPatternMatchListenerDelegate;
import org.eclipse.ui.console.PatternMatchEvent;
import org.eclipse.ui.console.TextConsole;

public class RubyConsoleTracker
implements IPatternMatchListenerDelegate {
    private TextConsole fConsole;

    public void connect(TextConsole console) {
        this.fConsole = console;
    }

    public void disconnect() {
        this.fConsole = null;
    }

    protected TextConsole getConsole() {
        return this.fConsole;
    }

    public void matchFound(PatternMatchEvent event) {
        try {
            int offset = event.getOffset();
            int length = event.getLength();
            String text = this.getConsole().getDocument().get(offset, length);
            if (this.isValidLink(text)) {
                RubyFileHyperlink link = new RubyFileHyperlink(this.fConsole);
                this.fConsole.addHyperlink((IHyperlink)link, offset, length);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private boolean isValidLink(String text) {
        try {
            String fileName = RubyFileHyperlink.extractFileName(text);
            if (fileName.length() > 1) {
                return RubyFileHyperlink.findSourceModule(fileName) != null;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return false;
    }
}

