/**
 * Copyright (c) 2010-2016, Abel Hegedus, IncQuery Labs Ltd.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * Contributors:
 * Abel Hegedus - initial API and implementation
 */
package org.eclipse.viatra.query.tooling.ui.queryregistry;

import org.eclipse.viatra.query.patternlanguage.emf.ui.EMFPatternLanguageUIPlugin;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistryEntry;
import org.eclipse.viatra.query.tooling.ui.queryregistry.QueryRegistryTreePackage;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Pure;

@FinalFieldsConstructor
@SuppressWarnings("all")
public class QueryRegistryTreeEntry {
  @Accessors(AccessorType.PUBLIC_GETTER)
  private final QueryRegistryTreePackage parent;
  
  @Accessors(AccessorType.PUBLIC_GETTER)
  private final IQuerySpecificationRegistryEntry entry;
  
  @Accessors(AccessorType.PUBLIC_GETTER)
  private boolean isLoaded = false;
  
  public boolean load() {
    boolean _isLoaded = this.isLoaded();
    boolean _not = (!_isLoaded);
    if (_not) {
      try {
        final IQuerySpecification<?> specification = this.entry.get();
        if ((specification != null)) {
          this.isLoaded = true;
        }
        return true;
      } catch (final Throwable _t) {
        if (_t instanceof Exception) {
          final Exception ex = (Exception)_t;
          final String logMessage = String.format("Query Registry has encountered an error during loading of query %s: %s", this.entry.getFullyQualifiedName(), ex.getMessage());
          EMFPatternLanguageUIPlugin.getInstance().logException(logMessage, ex);
        } else {
          throw Exceptions.sneakyThrow(_t);
        }
      }
    }
    return false;
  }
  
  public String getSimpleName() {
    String _xblockexpression = null;
    {
      final String fqn = this.entry.getFullyQualifiedName();
      final int lastDotIndex = fqn.lastIndexOf(".");
      String _xifexpression = null;
      if (((lastDotIndex > 0) && (lastDotIndex < fqn.length()))) {
        _xifexpression = fqn.substring((lastDotIndex + 1), fqn.length());
      } else {
        return fqn;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
  
  public String getPackageName() {
    String _xblockexpression = null;
    {
      final String fqn = this.entry.getFullyQualifiedName();
      final int lastDotIndex = fqn.lastIndexOf(".");
      String _xifexpression = null;
      if (((lastDotIndex > 0) && (lastDotIndex < fqn.length()))) {
        _xifexpression = fqn.substring(0, fqn.lastIndexOf("."));
      } else {
        return fqn;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
  
  @Pure
  public QueryRegistryTreePackage getParent() {
    return this.parent;
  }
  
  @Pure
  public IQuerySpecificationRegistryEntry getEntry() {
    return this.entry;
  }
  
  @Pure
  public boolean isLoaded() {
    return this.isLoaded;
  }
  
  public QueryRegistryTreeEntry(final QueryRegistryTreePackage parent, final IQuerySpecificationRegistryEntry entry) {
    super();
    this.parent = parent;
    this.entry = entry;
  }
}
