/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.statistics;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.core.Activator;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.StateSystemBuilderUtils;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfLostEvent;
import org.eclipse.tracecompass.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class TmfStatisticsEventTypesModule
extends TmfStateSystemAnalysisModule {
    public static final @NonNull String ID = "org.eclipse.linuxtools.tmf.statistics.types";
    private static final @NonNull String NAME = "TMF Statistics, events per type";

    public TmfStatisticsEventTypesModule() {
        this.setId(ID);
        this.setName(NAME);
    }

    @Override
    protected ITmfStateProvider createStateProvider() {
        return new StatsProviderEventTypes((ITmfTrace)NonNullUtils.checkNotNull((Object)this.getTrace()));
    }

    @Override
    protected String getSsFileName() {
        return "statistics-types.ht";
    }

    class StatsProviderEventTypes
    extends AbstractTmfStateProvider {
        private static final int VERSION = 3;

        public StatsProviderEventTypes(ITmfTrace trace) {
            super(trace, TmfStatisticsEventTypesModule.NAME);
        }

        @Override
        public int getVersion() {
            return 3;
        }

        @Override
        public StatsProviderEventTypes getNewInstance() {
            return new StatsProviderEventTypes(this.getTrace());
        }

        @Override
        protected void eventHandle(ITmfEvent event) {
            ITmfStateSystemBuilder ss = (ITmfStateSystemBuilder)NonNullUtils.checkNotNull((Object)this.getStateSystemBuilder());
            long ts = event.getTimestamp().toNanos();
            String eventName = event.getName();
            try {
                if (event instanceof ITmfLostEvent) {
                    ITmfLostEvent le = (ITmfLostEvent)event;
                    int quark = ss.getQuarkAbsoluteAndAdd(new String[]{"event_types", eventName});
                    int curVal = ss.queryOngoingState(quark).unboxInt();
                    if (curVal == -1) {
                        curVal = 0;
                    }
                    ss.modifyAttribute(ts, (Object)((int)((long)curVal + le.getNbLostEvents())), quark);
                    long lostEventsStartTime = le.getTimeRange().getStartTime().toNanos();
                    long lostEventsEndTime = le.getTimeRange().getEndTime().toNanos();
                    int lostEventsQuark = ss.getQuarkAbsoluteAndAdd(new String[]{"lost_events"});
                    ITmfStateValue currentLostEventsEndTime = ss.queryOngoingState(lostEventsQuark);
                    if (currentLostEventsEndTime.isNull() || currentLostEventsEndTime.unboxLong() < lostEventsStartTime) {
                        ss.modifyAttribute(lostEventsStartTime, (Object)lostEventsEndTime, lostEventsQuark);
                    } else if (currentLostEventsEndTime.unboxLong() < lostEventsEndTime) {
                        ss.updateOngoingState((ITmfStateValue)TmfStateValue.newValueLong((long)lostEventsEndTime), lostEventsQuark);
                    }
                    return;
                }
                int quark = ss.getQuarkAbsoluteAndAdd(new String[]{"event_types", eventName});
                StateSystemBuilderUtils.incrementAttributeInt((ITmfStateSystemBuilder)ss, (long)ts, (int)quark, (int)1);
            }
            catch (AttributeNotFoundException e) {
                Activator.logError("Get attribute not found exception ", e);
            }
        }
    }
}

