/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import org.eclipse.persistence.core.queries.CoreAttributeGroup;
import org.eclipse.persistence.core.sessions.CoreSession;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.core.helper.CoreClassConstants;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.oxm.CharacterEscapeHandler;
import org.eclipse.persistence.internal.oxm.Context;
import org.eclipse.persistence.internal.oxm.ConversionManager;
import org.eclipse.persistence.internal.oxm.Marshaller;
import org.eclipse.persistence.internal.oxm.MediaType;
import org.eclipse.persistence.internal.oxm.NamespacePrefixMapper;
import org.eclipse.persistence.internal.oxm.NamespaceResolver;
import org.eclipse.persistence.internal.oxm.ObjectBuilder;
import org.eclipse.persistence.internal.oxm.Root;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.mappings.Descriptor;
import org.eclipse.persistence.internal.oxm.mappings.Field;
import org.eclipse.persistence.internal.oxm.record.AbstractMarshalRecord;
import org.eclipse.persistence.internal.oxm.record.ExtendedResult;
import org.eclipse.persistence.internal.oxm.record.namespaces.PrefixMapperNamespaceResolver;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.oxm.JSONWithPadding;
import org.eclipse.persistence.oxm.attachment.XMLAttachmentMarshaller;
import org.eclipse.persistence.oxm.record.ContentHandlerRecord;
import org.eclipse.persistence.oxm.record.FormattedOutputStreamRecord;
import org.eclipse.persistence.oxm.record.FormattedWriterRecord;
import org.eclipse.persistence.oxm.record.JSONFormattedWriterRecord;
import org.eclipse.persistence.oxm.record.JSONWriterRecord;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.eclipse.persistence.oxm.record.NodeRecord;
import org.eclipse.persistence.oxm.record.OutputStreamRecord;
import org.eclipse.persistence.oxm.record.ValidatingMarshalRecord;
import org.eclipse.persistence.oxm.record.WriterRecord;
import org.eclipse.persistence.platform.xml.XMLPlatform;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.eclipse.persistence.platform.xml.XMLTransformer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.ext.LexicalHandler;

public abstract class XMLMarshaller<ABSTRACT_SESSION extends CoreAbstractSession, CHARACTER_ESCAPE_HANDLER extends CharacterEscapeHandler, CONTEXT extends Context<ABSTRACT_SESSION, DESCRIPTOR, ?, ?, ?, SESSION, ?>, DESCRIPTOR extends Descriptor<?, ?, ?, ?, ?, ?, ?, ?, ?, ?>, MARSHALLER_LISTENER extends Marshaller.Listener, MEDIA_TYPE extends MediaType, NAMESPACE_PREFIX_MAPPER extends NamespacePrefixMapper, OBJECT_BUILDER extends ObjectBuilder<?, ABSTRACT_SESSION, ?, XMLMarshaller>, SESSION extends CoreSession>
extends Marshaller<CHARACTER_ESCAPE_HANDLER, CONTEXT, MARSHALLER_LISTENER, MEDIA_TYPE, NAMESPACE_PREFIX_MAPPER> {
    protected static final String DEFAULT_XML_VERSION = "1.0";
    private static final String STAX_RESULT_CLASS_NAME = "javax.xml.transform.stax.StAXResult";
    private static final String GET_XML_STREAM_WRITER_METHOD_NAME = "getXMLStreamWriter";
    private static final String GET_XML_EVENT_WRITER_METHOD_NAME = "getXMLEventWriter";
    private static final String XML_STREAM_WRITER_RECORD_CLASS_NAME = "org.eclipse.persistence.oxm.record.XMLStreamWriterRecord";
    private static final String XML_EVENT_WRITER_RECORD_CLASS_NAME = "org.eclipse.persistence.oxm.record.XMLEventWriterRecord";
    private static final String XML_STREAM_WRITER_CLASS_NAME = "javax.xml.stream.XMLStreamWriter";
    private static final String XML_EVENT_WRITER_CLASS_NAME = "javax.xml.stream.XMLEventWriter";
    private static final String DOM_TO_STREAM_WRITER_CLASS_NAME = "org.eclipse.persistence.internal.oxm.record.DomToXMLStreamWriter";
    private static final String DOM_TO_EVENT_WRITER_CLASS_NAME = "org.eclipse.persistence.internal.oxm.record.DomToXMLEventWriter";
    private static final String WRITE_TO_STREAM_METHOD_NAME = "writeToStream";
    private static final String WRITE_TO_EVENT_WRITER_METHOD_NAME = "writeToEventWriter";
    protected static Class staxResultClass;
    protected static Method staxResultGetStreamWriterMethod;
    protected static Method staxResultGetEventWriterMethod;
    private static Constructor xmlStreamWriterRecordConstructor;
    private static Constructor xmlEventWriterRecordConstructor;
    protected static Method writeToStreamMethod;
    protected static Method writeToEventWriterMethod;
    protected static Class domToStreamWriterClass;
    protected static Class domToEventWriterClass;
    protected XMLAttachmentMarshaller attachmentMarshaller;
    private String attributePrefix;
    private boolean fragment;
    private boolean includeRoot = true;
    private boolean marshalEmptyCollections = true;
    protected MEDIA_TYPE mediaType;
    private char namespaceSeparator;
    private String noNamespaceSchemaLocation;
    private boolean reduceAnyArrays;
    private Schema schema;
    private String schemaLocation;
    protected XMLTransformer transformer;
    private String valueWrapper;
    private boolean wrapperAsCollectionName = false;
    private String xmlHeader;
    private Object marshalAttributeGroup;

    static {
        try {
            staxResultClass = PrivilegedAccessHelper.getClassForName(STAX_RESULT_CLASS_NAME);
            if (staxResultClass != null) {
                staxResultGetStreamWriterMethod = PrivilegedAccessHelper.getDeclaredMethod(staxResultClass, GET_XML_STREAM_WRITER_METHOD_NAME, new Class[0]);
                staxResultGetEventWriterMethod = PrivilegedAccessHelper.getDeclaredMethod(staxResultClass, GET_XML_EVENT_WRITER_METHOD_NAME, new Class[0]);
            }
            Class streamWriterRecordClass = PrivilegedAccessHelper.getClassForName(XML_STREAM_WRITER_RECORD_CLASS_NAME);
            Class streamWriterClass = PrivilegedAccessHelper.getClassForName(XML_STREAM_WRITER_CLASS_NAME);
            xmlStreamWriterRecordConstructor = PrivilegedAccessHelper.getConstructorFor(streamWriterRecordClass, new Class[]{streamWriterClass}, true);
            Class eventWriterRecordClass = PrivilegedAccessHelper.getClassForName(XML_EVENT_WRITER_RECORD_CLASS_NAME);
            Class eventWriterClass = PrivilegedAccessHelper.getClassForName(XML_EVENT_WRITER_CLASS_NAME);
            xmlEventWriterRecordConstructor = PrivilegedAccessHelper.getConstructorFor(eventWriterRecordClass, new Class[]{eventWriterClass}, true);
            domToStreamWriterClass = PrivilegedAccessHelper.getClassForName(DOM_TO_STREAM_WRITER_CLASS_NAME);
            writeToStreamMethod = PrivilegedAccessHelper.getMethod(domToStreamWriterClass, WRITE_TO_STREAM_METHOD_NAME, new Class[]{CoreClassConstants.NODE, CoreClassConstants.STRING, CoreClassConstants.STRING, streamWriterClass}, true);
            domToEventWriterClass = PrivilegedAccessHelper.getClassForName(DOM_TO_EVENT_WRITER_CLASS_NAME);
            writeToEventWriterMethod = PrivilegedAccessHelper.getMethod(domToEventWriterClass, WRITE_TO_EVENT_WRITER_METHOD_NAME, new Class[]{CoreClassConstants.NODE, CoreClassConstants.STRING, CoreClassConstants.STRING, eventWriterClass}, true);
        }
        catch (Exception exception) {}
    }

    public XMLMarshaller(CONTEXT context) {
        super(context);
        this.includeRoot = true;
        this.marshalEmptyCollections = true;
        this.namespaceSeparator = (char)46;
        this.reduceAnyArrays = false;
        this.valueWrapper = "value";
    }

    protected XMLMarshaller(XMLMarshaller xmlMarshaller) {
        super(xmlMarshaller);
        this.attachmentMarshaller = xmlMarshaller.getAttachmentMarshaller();
        this.attributePrefix = xmlMarshaller.getAttributePrefix();
        this.fragment = xmlMarshaller.isFragment();
        this.includeRoot = xmlMarshaller.isIncludeRoot();
        this.marshalEmptyCollections = xmlMarshaller.isMarshalEmptyCollections();
        this.mediaType = xmlMarshaller.mediaType;
        this.namespaceSeparator = xmlMarshaller.getNamespaceSeparator();
        this.noNamespaceSchemaLocation = xmlMarshaller.getNoNamespaceSchemaLocation();
        this.reduceAnyArrays = xmlMarshaller.isReduceAnyArrays();
        if (xmlMarshaller.getSchema() != null) {
            this.setSchema(xmlMarshaller.getSchema());
        }
        this.schemaLocation = xmlMarshaller.getSchemaLocation();
        this.valueWrapper = xmlMarshaller.getValueWrapper();
        this.wrapperAsCollectionName = xmlMarshaller.isWrapperAsCollectionName();
        this.xmlHeader = xmlMarshaller.getXmlHeader();
    }

    protected void addDescriptorNamespacesToXMLRecord(DESCRIPTOR xmlDescriptor, AbstractMarshalRecord record) {
        if (xmlDescriptor == null) {
            return;
        }
        this.copyNamespaces((NamespaceResolver)xmlDescriptor.getNamespaceResolver(), (NamespaceResolver)record.getNamespaceResolver());
    }

    private XPathFragment buildRootFragment(Object object, DESCRIPTOR descriptor, boolean isXMLRoot, MarshalRecord marshalRecord) {
        XPathFragment rootFragment = null;
        if (isXMLRoot) {
            String xmlRootUri = ((Root)object).getNamespaceURI();
            String xmlRootLocalName = ((Root)object).getLocalName();
            rootFragment = new XPathFragment();
            rootFragment.setLocalName(xmlRootLocalName);
            rootFragment.setNamespaceURI(xmlRootUri);
            rootFragment.setNamespaceAware(marshalRecord.isNamespaceAware());
            rootFragment.setNamespaceSeparator(marshalRecord.getNamespaceSeparator());
            if (xmlRootUri != null) {
                if (descriptor != null) {
                    String xmlRootPrefix = ((NamespaceResolver)marshalRecord.getNamespaceResolver()).resolveNamespaceURI(xmlRootUri);
                    if (xmlRootPrefix == null && !xmlRootUri.equals(((NamespaceResolver)marshalRecord.getNamespaceResolver()).getDefaultNamespaceURI())) {
                        xmlRootPrefix = ((NamespaceResolver)marshalRecord.getNamespaceResolver()).generatePrefix();
                        ((NamespaceResolver)marshalRecord.getNamespaceResolver()).put(xmlRootPrefix, xmlRootUri);
                    }
                    if (xmlRootPrefix == null) {
                        rootFragment.setXPath(xmlRootLocalName);
                    } else {
                        rootFragment.setPrefix(xmlRootPrefix);
                    }
                } else if (marshalRecord.isNamespaceAware()) {
                    String xmlRootPrefix = "ns0";
                    ((NamespaceResolver)marshalRecord.getNamespaceResolver()).put(xmlRootPrefix, xmlRootUri);
                    rootFragment.setXPath(String.valueOf(xmlRootPrefix) + marshalRecord.getNamespaceSeparator() + xmlRootLocalName);
                } else {
                    rootFragment.setXPath(xmlRootLocalName);
                }
            }
        } else {
            Field defaultRootField = descriptor.getDefaultRootElementField();
            if (defaultRootField != null) {
                rootFragment = defaultRootField.getXPathFragment();
            }
        }
        return rootFragment;
    }

    protected void copyNamespaces(NamespaceResolver source, NamespaceResolver target) {
        if (source != null && target != null) {
            if (source.hasPrefixesToNamespaces()) {
                target.getPrefixesToNamespaces().putAll(source.getPrefixesToNamespaces());
            }
            target.setDefaultNamespaceURI(source.getDefaultNamespaceURI());
        }
    }

    @Override
    public XMLAttachmentMarshaller getAttachmentMarshaller() {
        return this.attachmentMarshaller;
    }

    public String getAttributePrefix() {
        return this.attributePrefix;
    }

    protected DESCRIPTOR getDescriptor(Class clazz, ABSTRACT_SESSION session) throws XMLMarshalException {
        Descriptor descriptor = (Descriptor)session.getDescriptor(clazz);
        if (descriptor == null) {
            throw XMLMarshalException.descriptorNotFoundInProject(clazz.getName());
        }
        return (DESCRIPTOR)descriptor;
    }

    public DESCRIPTOR getDescriptor(Object object) throws XMLMarshalException {
        Descriptor descriptor = (Descriptor)this.context.getSession(object).getDescriptor(object);
        if (descriptor == null) {
            throw XMLMarshalException.descriptorNotFoundInProject(object.getClass().getName());
        }
        return (DESCRIPTOR)descriptor;
    }

    protected DESCRIPTOR getDescriptor(Object object, ABSTRACT_SESSION session) throws XMLMarshalException {
        Descriptor descriptor = (Descriptor)session.getDescriptor(object);
        if (descriptor == null) {
            throw XMLMarshalException.descriptorNotFoundInProject(object.getClass().getName());
        }
        return (DESCRIPTOR)descriptor;
    }

    protected DESCRIPTOR getDescriptor(Object object, boolean isXMLRoot) {
        if (isXMLRoot) {
            return this.getDescriptor((Root)object);
        }
        return this.getDescriptor(object);
    }

    protected DESCRIPTOR getDescriptor(Root object) throws XMLMarshalException {
        Object session;
        Descriptor descriptor;
        block5: {
            descriptor = null;
            try {
                session = this.context.getSession(object.getObject());
                if (session != null) break block5;
            }
            catch (XMLMarshalException marshalException) {
                if (descriptor == null && this.isSimpleXMLRoot(object)) {
                    return null;
                }
                throw marshalException;
            }
            return null;
        }
        descriptor = (Descriptor)session.getDescriptor(object.getObject());
        if (descriptor == null) {
            throw XMLMarshalException.descriptorNotFoundInProject(object.getClass().getName());
        }
        return (DESCRIPTOR)descriptor;
    }

    protected DESCRIPTOR getDescriptor(Root object, ABSTRACT_SESSION session) throws XMLMarshalException {
        Descriptor descriptor;
        block5: {
            descriptor = null;
            try {
                if (session != null) break block5;
            }
            catch (XMLMarshalException marshalException) {
                if (descriptor == null && this.isSimpleXMLRoot(object)) {
                    return null;
                }
                throw marshalException;
            }
            return null;
        }
        descriptor = (Descriptor)session.getDescriptor(object.getObject());
        if (descriptor == null) {
            throw XMLMarshalException.descriptorNotFoundInProject(object.getClass().getName());
        }
        return (DESCRIPTOR)descriptor;
    }

    protected Node getNode(Object object, Node parentNode, ABSTRACT_SESSION session, DESCRIPTOR descriptor, boolean isRoot) {
        if (isRoot && (object = ((Root)object).getObject()) instanceof Node) {
            return (Node)object;
        }
        return null;
    }

    public String getNoNamespaceSchemaLocation() {
        return this.noNamespaceSchemaLocation;
    }

    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public XMLTransformer getTransformer() {
        if (this.transformer == null) {
            XMLPlatform xmlPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
            this.transformer = xmlPlatform.newXMLTransformer();
            this.transformer.setEncoding(this.getEncoding());
            this.transformer.setFormattedOutput(this.isFormattedOutput());
            this.transformer.setFragment(this.fragment);
        }
        return this.transformer;
    }

    public String getValueWrapper() {
        return this.valueWrapper;
    }

    public String getXmlHeader() {
        return this.xmlHeader;
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    @Override
    public boolean isApplicationJSON() {
        return this.mediaType != null && this.mediaType.isApplicationJSON();
    }

    @Override
    public boolean isApplicationXML() {
        return this.mediaType == null || this.mediaType.isApplicationXML();
    }

    public boolean isFragment() {
        return this.isApplicationXML() && this.fragment;
    }

    @Override
    public boolean isIncludeRoot() {
        if (this.isApplicationJSON()) {
            return this.includeRoot;
        }
        return true;
    }

    @Override
    public boolean isReduceAnyArrays() {
        return this.reduceAnyArrays;
    }

    public char getNamespaceSeparator() {
        return this.namespaceSeparator;
    }

    public boolean isMarshalEmptyCollections() {
        return this.marshalEmptyCollections;
    }

    @Override
    public boolean isWrapperAsCollectionName() {
        return this.wrapperAsCollectionName;
    }

    protected boolean isSimpleXMLRoot(Root xmlRoot) {
        Class<?> xmlRootObjectClass = xmlRoot.getObject().getClass();
        ConversionManager conversionManager = (ConversionManager)this.context.getSession().getDatasourcePlatform().getConversionManager();
        if (conversionManager.schemaType(xmlRootObjectClass) != null || CoreClassConstants.List_Class.isAssignableFrom(xmlRootObjectClass) || CoreClassConstants.XML_GREGORIAN_CALENDAR.isAssignableFrom(xmlRootObjectClass) || CoreClassConstants.DURATION.isAssignableFrom(xmlRootObjectClass)) {
            return true;
        }
        return xmlRoot.getObject() instanceof Node;
    }

    public void marshal(Object object, ContentHandler contentHandler) throws XMLMarshalException {
        this.marshal(object, contentHandler, null);
    }

    /*
     * Unable to fully structure code
     */
    public void marshal(Object object, ContentHandler contentHandler, LexicalHandler lexicalHandler) throws XMLMarshalException {
        if (object instanceof JSONWithPadding && !this.isApplicationJSON()) {
            object = ((JSONWithPadding)object).getObject();
        }
        if (object == null || contentHandler == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        session = null;
        xmlDescriptor = null;
        isXMLRoot = object instanceof Root;
        if (isXMLRoot) {
            try {
                session = this.context.getSession(((Root)object).getObject());
                if (session == null) ** GOTO lbl20
                xmlDescriptor = this.getDescriptor(((Root)object).getObject(), session);
            }
            catch (XMLMarshalException marshalException) {
                if (this.isSimpleXMLRoot((Root)object)) ** GOTO lbl20
                throw marshalException;
            }
        } else {
            objectClass = object.getClass();
            session = this.context.getSession(objectClass);
            xmlDescriptor = this.getDescriptor(objectClass, session);
        }
lbl20:
        // 4 sources

        contentHandlerRecord = new ContentHandlerRecord();
        contentHandlerRecord.setMarshaller(this);
        contentHandlerRecord.setContentHandler(contentHandler);
        contentHandlerRecord.setLexicalHandler(lexicalHandler);
        this.marshal(object, contentHandlerRecord, session, xmlDescriptor, isXMLRoot);
    }

    /*
     * Unable to fully structure code
     */
    public void marshal(Object object, MarshalRecord marshalRecord) {
        if (object instanceof JSONWithPadding && !this.isApplicationJSON()) {
            object = ((JSONWithPadding)object).getObject();
        }
        if (object == null || marshalRecord == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        isXMLRoot = object instanceof Root;
        session = null;
        xmlDescriptor = null;
        if (isXMLRoot) {
            try {
                session = this.context.getSession(((Root)object).getObject());
                if (session == null) ** GOTO lbl20
                xmlDescriptor = this.getDescriptor(((Root)object).getObject(), session);
            }
            catch (XMLMarshalException marshalException) {
                if (this.isSimpleXMLRoot((Root)object)) ** GOTO lbl20
                throw marshalException;
            }
        } else {
            objectClass = object.getClass();
            session = this.context.getSession(objectClass);
            xmlDescriptor = this.getDescriptor(objectClass, session);
        }
lbl20:
        // 4 sources

        this.marshal(object, marshalRecord, session, xmlDescriptor, isXMLRoot);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void marshal(Object object, MarshalRecord marshalRecord, ABSTRACT_SESSION session22, DESCRIPTOR descriptor, boolean isXMLRoot) {
        void session22;
        if (this.schema != null) {
            marshalRecord = new ValidatingMarshalRecord(marshalRecord, this);
        }
        if (this.attachmentMarshaller != null) {
            marshalRecord.setXOPPackage(this.attachmentMarshaller.isXOPPackage());
        }
        marshalRecord.setMarshaller(this);
        Root root = null;
        if (isXMLRoot != false) {
            root = (Root)object;
        }
        Node node = this.getNode(object, marshalRecord.getDOM(), session22, descriptor, (boolean)isXMLRoot);
        if (this.mapper == null) {
            if (node == null) {
                this.addDescriptorNamespacesToXMLRecord(descriptor, marshalRecord);
            }
        } else {
            if (descriptor == null || node != null) {
                marshalRecord.setNamespaceResolver(new PrefixMapperNamespaceResolver(this.mapper, null));
            } else {
                marshalRecord.setNamespaceResolver(new PrefixMapperNamespaceResolver(this.mapper, (NamespaceResolver)descriptor.getNamespaceResolver()));
            }
            marshalRecord.setCustomNamespaceMapper(true);
        }
        if (this.getMarshalAttributeGroup() != null) {
            if (this.marshalAttributeGroup.getClass() == CoreClassConstants.STRING) {
                CoreAttributeGroup group = descriptor.getAttributeGroup((String)this.marshalAttributeGroup);
                if (group == null) throw XMLMarshalException.invalidAttributeGroupName((String)this.marshalAttributeGroup, descriptor.getJavaClassName());
                marshalRecord.pushAttributeGroup(group);
            } else if (this.marshalAttributeGroup instanceof CoreAttributeGroup) {
                marshalRecord.pushAttributeGroup((CoreAttributeGroup)this.marshalAttributeGroup);
            }
        }
        Object nr = marshalRecord.getNamespaceResolver();
        if (node != null) {
            if (isXMLRoot != false) {
                if (this.isFragment()) {
                    marshalRecord.node(node, null, root.getNamespaceURI(), root.getLocalName());
                } else {
                    String version;
                    String encoding = root.getEncoding();
                    if (encoding == null) {
                        encoding = "UTF-8";
                    }
                    if ((version = root.getXMLVersion()) == null) {
                        version = DEFAULT_XML_VERSION;
                    }
                    marshalRecord.startDocument(encoding, version);
                    marshalRecord.node(node, (NamespaceResolver)marshalRecord.getNamespaceResolver(), root.getNamespaceURI(), root.getLocalName());
                    marshalRecord.endDocument();
                }
            } else {
                marshalRecord.node(node, (NamespaceResolver)nr);
            }
            marshalRecord.flush();
            return;
        }
        if (isXMLRoot != false) {
            if (descriptor != null) {
                marshalRecord.beforeContainmentMarshal(root.getObject());
            }
        } else {
            marshalRecord.beforeContainmentMarshal(object);
        }
        if (!this.isFragment()) {
            String encoding = this.getEncoding();
            String version = DEFAULT_XML_VERSION;
            if (isXMLRoot == false && descriptor != null) {
                marshalRecord.setLeafElementType(descriptor.getDefaultRootElementType());
            } else {
                if (root.getEncoding() != null) {
                    encoding = root.getEncoding();
                }
                if (root.getXMLVersion() != null) {
                    version = root.getXMLVersion();
                }
            }
            marshalRecord.startDocument(encoding, version);
        }
        if (this.getXmlHeader() != null) {
            marshalRecord.writeHeader();
        }
        if (isXMLRoot != false && root.getObject() instanceof Node) {
            marshalRecord.node((Node)root.getObject(), new NamespaceResolver(), root.getNamespaceURI(), root.getLocalName());
            marshalRecord.endDocument();
            return;
        }
        XPathFragment rootFragment = this.buildRootFragment(object, descriptor, (boolean)isXMLRoot, marshalRecord);
        String schemaLocation = this.getSchemaLocation();
        String noNsSchemaLocation = this.getNoNamespaceSchemaLocation();
        boolean isNil = false;
        if (isXMLRoot != false) {
            object = root.getObject();
            if (root.getSchemaLocation() != null) {
                schemaLocation = root.getSchemaLocation();
            }
            if (root.getNoNamespaceSchemaLocation() != null) {
                noNsSchemaLocation = root.getNoNamespaceSchemaLocation();
            }
            marshalRecord.setLeafElementType(root.getSchemaType());
            isNil = root.isNil();
        }
        String xsiPrefix = null;
        if ((this.getSchemaLocation() != null || this.getNoNamespaceSchemaLocation() != null || isNil) && (xsiPrefix = ((NamespaceResolver)nr).resolveNamespaceURI("http://www.w3.org/2001/XMLSchema-instance")) == null) {
            xsiPrefix = "xsi";
            ((NamespaceResolver)nr).put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        }
        ObjectBuilder treeObjectBuilder = null;
        if (descriptor != null) {
            treeObjectBuilder = (ObjectBuilder)descriptor.getObjectBuilder();
        }
        if (session22 == null) {
            CoreAbstractSession session22 = (CoreAbstractSession)this.context.getSession();
        }
        marshalRecord.setSession((CoreAbstractSession)session22);
        if (rootFragment != null && !rootFragment.getLocalName().equals("")) {
            marshalRecord.startPrefixMappings((NamespaceResolver)nr);
            if (isXMLRoot == false && descriptor != null && descriptor.getNamespaceResolver() == null && rootFragment.hasNamespace()) {
                throw XMLMarshalException.namespaceResolverNotSpecified(rootFragment.getShortName());
            }
            if (this.isIncludeRoot()) {
                marshalRecord.openStartElement(rootFragment, (NamespaceResolver)nr);
            }
            if (schemaLocation != null) {
                marshalRecord.attributeWithoutQName("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", xsiPrefix, schemaLocation);
            }
            if (noNsSchemaLocation != null) {
                marshalRecord.attributeWithoutQName("http://www.w3.org/2001/XMLSchema-instance", "noNamespaceSchemaLocation", xsiPrefix, noNsSchemaLocation);
            }
            if (isNil) {
                marshalRecord.nilSimple((NamespaceResolver)nr);
            }
            marshalRecord.namespaceDeclarations((NamespaceResolver)nr);
            if (descriptor != null && !isNil) {
                marshalRecord.addXsiTypeAndClassIndicatorIfRequired((Descriptor)descriptor, null, descriptor.getDefaultRootElementField(), root, object, (boolean)isXMLRoot, true);
                treeObjectBuilder.marshalAttributes(marshalRecord, object, (CoreAbstractSession)session22);
            }
            if (this.isIncludeRoot()) {
                marshalRecord.closeStartElement();
            }
        } else {
            marshalRecord.marshalWithoutRootElement(treeObjectBuilder, object, (Descriptor)descriptor, root, (boolean)isXMLRoot);
        }
        if (treeObjectBuilder != null && !isNil) {
            treeObjectBuilder.buildRow(marshalRecord, object, (CoreAbstractSession)session22, this, rootFragment);
        } else if (isXMLRoot != false && object != null && !isNil) {
            QName type;
            if (root.getDeclaredType() != null && root.getObject() != null && root.getDeclaredType() != root.getObject().getClass() && (type = marshalRecord.getConversionManager().schemaType(object.getClass())) != null) {
                xsiPrefix = ((NamespaceResolver)nr).resolveNamespaceURI("http://www.w3.org/2001/XMLSchema-instance");
                if (xsiPrefix == null) {
                    xsiPrefix = "xsi";
                    marshalRecord.namespaceDeclaration(xsiPrefix, "http://www.w3.org/2001/XMLSchema-instance");
                }
                marshalRecord.namespaceDeclaration("xsd", "http://www.w3.org/2001/XMLSchema");
                String typeValue = type.getLocalPart();
                if (marshalRecord.isNamespaceAware() && (this.mediaType.isApplicationXML() || this.getJsonTypeConfiguration().useXsdTypesWithPrefix())) {
                    typeValue = "xsd" + marshalRecord.getNamespaceSeparator() + typeValue;
                }
                marshalRecord.attribute("http://www.w3.org/2001/XMLSchema-instance", "type", String.valueOf(xsiPrefix) + ':' + "type", typeValue);
            }
            marshalRecord.characters(root.getSchemaType(), object, null, false);
        }
        if (rootFragment != null && !rootFragment.getLocalName().equals("") && this.isIncludeRoot()) {
            marshalRecord.endElement(rootFragment, (NamespaceResolver)nr);
            marshalRecord.endPrefixMappings((NamespaceResolver)nr);
        }
        if (!this.isFragment()) {
            marshalRecord.endDocument();
        }
        if (isXMLRoot != false) {
            if (descriptor == null) return;
            marshalRecord.afterContainmentMarshal(null, root.getObject());
            return;
        } else {
            marshalRecord.afterContainmentMarshal(null, object);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void marshal(Object object, Node node) throws XMLMarshalException {
        if (object instanceof JSONWithPadding && !this.isApplicationJSON()) {
            object = ((JSONWithPadding)object).getObject();
        }
        if (object == null || node == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        session = null;
        xmlDescriptor = null;
        isXMLRoot = object instanceof Root;
        if (isXMLRoot) {
            try {
                session = this.context.getSession(((Root)object).getObject());
                if (session == null) ** GOTO lbl20
                xmlDescriptor = (Descriptor)this.getDescriptor(((Root)object).getObject(), session);
            }
            catch (XMLMarshalException marshalException) {
                if (this.isSimpleXMLRoot((Root)object)) ** GOTO lbl20
                throw marshalException;
            }
        } else {
            objectClass = object.getClass();
            session = this.context.getSession(objectClass);
            xmlDescriptor = (Descriptor)this.getDescriptor(objectClass, session);
        }
lbl20:
        // 4 sources

        contentHandlerRecord = new NodeRecord(node);
        contentHandlerRecord.setMarshaller(this);
        if (!isXMLRoot && xmlDescriptor.getDefaultRootElement() == null && node.getNodeType() == 1 && xmlDescriptor.getSchemaReference() != null && xmlDescriptor.getSchemaReference().getType() == 1) {
            typeAttr = ((Element)node).getAttributeNodeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
            if (typeAttr == null) {
                namespaceResolver = xmlDescriptor.getNonNullNamespaceResolver();
                xsiPrefix = namespaceResolver.resolveNamespaceURI("http://www.w3.org/2001/XMLSchema-instance");
                if (xsiPrefix == null) {
                    xsiPrefix = namespaceResolver.generatePrefix("xsi");
                }
                value = xmlDescriptor.getSchemaReference().getSchemaContext();
                ((Element)node).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + xsiPrefix, "http://www.w3.org/2001/XMLSchema-instance");
                ((Element)node).setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", String.valueOf(xsiPrefix) + ':' + "type", value);
            } else {
                value = xmlDescriptor.getSchemaReference().getSchemaContext();
                typeAttr.setValue(value);
            }
        }
        this.marshal(object, contentHandlerRecord, session, xmlDescriptor, isXMLRoot);
    }

    public void marshal(Object object, OutputStream outputStream) throws XMLMarshalException {
        this.marshal(object, outputStream, null, null);
    }

    private void marshal(Object object, OutputStream outputStream, ABSTRACT_SESSION session, DESCRIPTOR xmlDescriptor) throws XMLMarshalException {
        MarshalRecord marshalRecord;
        if (object == null || outputStream == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        boolean isXMLRoot = false;
        String encoding = this.getEncoding();
        String callbackName = null;
        if (object instanceof JSONWithPadding) {
            callbackName = ((JSONWithPadding)object).getCallbackName();
            if ((object = ((JSONWithPadding)object).getObject()) == null) {
                throw XMLMarshalException.nullArgumentException();
            }
        }
        if (object instanceof Root) {
            isXMLRoot = true;
            Root xroot = (Root)object;
            String string = encoding = xroot.getEncoding() != null ? xroot.getEncoding() : encoding;
        }
        if (!encoding.equals("UTF-8")) {
            try {
                OutputStreamWriter writer = new OutputStreamWriter(outputStream, encoding);
                this.marshal(object, writer, session, xmlDescriptor);
                writer.flush();
            }
            catch (EclipseLinkException e) {
                throw e;
            }
            catch (Exception e) {
                throw XMLMarshalException.marshalException(e);
            }
            return;
        }
        if (this.isFormattedOutput()) {
            if (this.isApplicationJSON()) {
                marshalRecord = new JSONFormattedWriterRecord(outputStream, callbackName);
            } else {
                marshalRecord = new FormattedOutputStreamRecord();
                marshalRecord.setOutputStream(outputStream);
            }
        } else if (this.isApplicationJSON()) {
            marshalRecord = new JSONWriterRecord(outputStream, callbackName);
        } else {
            marshalRecord = new OutputStreamRecord();
            ((OutputStreamRecord)marshalRecord).setOutputStream(outputStream);
        }
        this.marshalStreamOrWriter(object, marshalRecord, session, xmlDescriptor, isXMLRoot);
    }

    /*
     * Unable to fully structure code
     */
    public void marshal(Object object, Result result) throws XMLMarshalException {
        block32: {
            if (object == null || result == null) {
                throw XMLMarshalException.nullArgumentException();
            }
            xmlDescriptor = null;
            session = null;
            isXMLRoot = object instanceof Root;
            if (isXMLRoot) {
                try {
                    session = this.context.getSession(((Root)object).getObject());
                    if (session == null) ** GOTO lbl18
                    xmlDescriptor = this.getDescriptor(((Root)object).getObject(), session);
                }
                catch (XMLMarshalException marshalException) {
                    if (this.isSimpleXMLRoot((Root)object)) ** GOTO lbl18
                    throw marshalException;
                }
            } else {
                objectClass = object.getClass();
                session = this.context.getSession(objectClass);
                xmlDescriptor = this.getDescriptor(objectClass, session);
            }
lbl18:
            // 4 sources

            if (!(result instanceof StreamResult)) ** GOTO lbl46
            streamResult = (StreamResult)result;
            writer = streamResult.getWriter();
            if (writer != null) {
                this.marshal(object, writer, session, xmlDescriptor);
            } else if (streamResult.getOutputStream() != null) {
                this.marshal(object, streamResult.getOutputStream(), session, xmlDescriptor);
            } else {
                try {
                    try {
                        f = new File(new URL(streamResult.getSystemId()).toURI());
                    }
                    catch (MalformedURLException malformedURLException) {
                        try {
                            f = new File(streamResult.getSystemId());
                        }
                        catch (Exception v0) {
                            throw malformedURLException;
                        }
                    }
                    writer = new FileWriter(f);
                    try {
                        this.marshal(object, writer, session, xmlDescriptor);
                        break block32;
                    }
                    finally {
                        writer.close();
                    }
                }
                catch (Exception e) {
                    throw XMLMarshalException.marshalException(e);
                }
lbl46:
                // 1 sources

                if (result instanceof DOMResult) {
                    domResult = (DOMResult)result;
                    if (domResult.getNode() == null) {
                        domResult.setNode(this.objectToXML(object));
                    } else {
                        this.marshal(object, domResult.getNode());
                    }
                } else if (result instanceof SAXResult) {
                    saxResult = (SAXResult)result;
                    this.marshal(object, saxResult.getHandler());
                } else if (result instanceof ExtendedResult) {
                    this.marshal(object, ((ExtendedResult)result).createRecord(), session, xmlDescriptor, isXMLRoot);
                } else {
                    if (result.getClass().equals(XMLMarshaller.staxResultClass)) {
                        try {
                            xmlStreamWriter = PrivilegedAccessHelper.invokeMethod(XMLMarshaller.staxResultGetStreamWriterMethod, result);
                            if (xmlStreamWriter != null) {
                                record = (MarshalRecord)PrivilegedAccessHelper.invokeConstructor(XMLMarshaller.xmlStreamWriterRecordConstructor, new Object[]{xmlStreamWriter});
                                record.setMarshaller(this);
                                this.marshal(object, record, session, xmlDescriptor, isXMLRoot);
                                return;
                            }
                            xmlEventWriter = PrivilegedAccessHelper.invokeMethod(XMLMarshaller.staxResultGetEventWriterMethod, result);
                            if (xmlEventWriter != null) {
                                record = (MarshalRecord)PrivilegedAccessHelper.invokeConstructor(XMLMarshaller.xmlEventWriterRecordConstructor, new Object[]{xmlEventWriter});
                                record.setMarshaller(this);
                                this.marshal(object, record, session, xmlDescriptor, isXMLRoot);
                                return;
                            }
                        }
                        catch (EclipseLinkException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            throw XMLMarshalException.marshalException(e);
                        }
                    }
                    writer = new StringWriter();
                    this.marshal(object, writer);
                    source = new StreamSource(new StringReader(writer.toString()));
                    this.getTransformer().transform(source, result);
                }
            }
        }
    }

    public void marshal(Object object, Writer writer) throws XMLMarshalException {
        this.marshal(object, writer, null, null);
    }

    private void marshal(Object object, Writer writer, ABSTRACT_SESSION session, DESCRIPTOR xmlDescriptor) throws XMLMarshalException {
        MarshalRecord marshalRecord;
        if (object == null || writer == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        boolean isXMLRoot = false;
        String version = DEFAULT_XML_VERSION;
        String encoding = this.getEncoding();
        String callbackName = null;
        if (object instanceof JSONWithPadding) {
            callbackName = ((JSONWithPadding)object).getCallbackName();
            if ((object = ((JSONWithPadding)object).getObject()) == null) {
                throw XMLMarshalException.nullArgumentException();
            }
        }
        if (object instanceof Root) {
            isXMLRoot = true;
            Root xroot = (Root)object;
            version = xroot.getXMLVersion() != null ? xroot.getXMLVersion() : version;
            encoding = xroot.getEncoding() != null ? xroot.getEncoding() : encoding;
        }
        writer = this.wrapWriter(writer);
        if (this.isFormattedOutput()) {
            if (this.isApplicationJSON()) {
                marshalRecord = new JSONFormattedWriterRecord(writer, callbackName);
            } else {
                marshalRecord = new FormattedWriterRecord();
                marshalRecord.setWriter(writer);
            }
        } else if (this.isApplicationJSON()) {
            marshalRecord = new JSONWriterRecord(writer, callbackName);
        } else {
            marshalRecord = new WriterRecord();
            ((WriterRecord)marshalRecord).setWriter(writer);
        }
        this.marshalStreamOrWriter(object, marshalRecord, session, xmlDescriptor, isXMLRoot);
    }

    /*
     * Unable to fully structure code
     */
    private void marshalStreamOrWriter(Object object, MarshalRecord marshalRecord, ABSTRACT_SESSION session, DESCRIPTOR descriptor, boolean isXMLRoot) {
        marshalRecord.setMarshaller(this);
        if (isXMLRoot) {
            if (session == null || descriptor == null) {
                try {
                    session = this.context.getSession(((Root)object).getObject());
                    if (session == null) ** GOTO lbl36
                    descriptor = this.getDescriptor(((Root)object).getObject(), session);
                }
                catch (XMLMarshalException marshalException) {
                    if (this.isSimpleXMLRoot((Root)object)) ** GOTO lbl36
                    throw marshalException;
                }
            }
        } else {
            objectClass = object.getClass();
            if (object instanceof Collection) {
                marshalRecord.startCollection();
                for (E o : (Collection)object) {
                    this.marshal(o, marshalRecord);
                }
                marshalRecord.endCollection();
                marshalRecord.flush();
                return;
            }
            if (objectClass.isArray()) {
                marshalRecord.startCollection();
                arrayLength = Array.getLength(object);
                x = 0;
                while (x < arrayLength) {
                    this.marshal(Array.get(object, x), marshalRecord);
                    ++x;
                }
                marshalRecord.endCollection();
                marshalRecord.flush();
                return;
            }
            if (session == null || descriptor == null) {
                session = this.context.getSession(objectClass);
                descriptor = this.getDescriptor(objectClass, session);
            }
        }
lbl36:
        // 7 sources

        this.marshal(object, marshalRecord, session, descriptor, isXMLRoot);
        marshalRecord.flush();
    }

    private Writer wrapWriter(Writer writer) {
        if (writer instanceof OutputStreamWriter || writer instanceof FileWriter) {
            return new BufferedWriter(writer);
        }
        return writer;
    }

    public Document objectToXML(Object object) throws XMLMarshalException {
        boolean isXMLRoot = object instanceof Root;
        DESCRIPTOR xmlDescriptor = this.getDescriptor(object, isXMLRoot);
        return this.objectToXML(object, xmlDescriptor, isXMLRoot);
    }

    protected Document objectToXML(Object object, DESCRIPTOR descriptor, boolean isXMLRoot) throws XMLMarshalException {
        Object session = this.context.getSession(descriptor);
        NodeRecord marshalRecord = new NodeRecord();
        marshalRecord.setMarshaller(this);
        this.marshal(object, marshalRecord, session, descriptor, isXMLRoot);
        return ((MarshalRecord)marshalRecord).getDocument();
    }

    protected Node objectToXMLNode(Object object, ABSTRACT_SESSION session, DESCRIPTOR descriptor, boolean isXMLRoot) throws XMLMarshalException {
        return this.objectToXMLNode(object, null, session, descriptor, isXMLRoot);
    }

    protected Node objectToXMLNode(Object object, Node rootNode, ABSTRACT_SESSION session, DESCRIPTOR descriptor, boolean isXMLRoot) throws XMLMarshalException {
        NodeRecord marshalRecord = new NodeRecord();
        marshalRecord.setMarshaller(this);
        ((NamespaceResolver)marshalRecord.getNamespaceResolver()).setDOM(rootNode);
        this.marshal(object, marshalRecord, session, descriptor, isXMLRoot);
        return ((MarshalRecord)marshalRecord).getDocument();
    }

    public void setAttachmentMarshaller(XMLAttachmentMarshaller atm) {
        this.attachmentMarshaller = atm;
    }

    public void setAttributePrefix(String attributePrefix) {
        this.attributePrefix = attributePrefix;
    }

    @Override
    public void setEncoding(String newEncoding) {
        super.setEncoding(newEncoding);
        if (this.transformer != null) {
            this.transformer.setEncoding(newEncoding);
        }
    }

    @Override
    public void setFormattedOutput(boolean shouldFormat) {
        super.setFormattedOutput(shouldFormat);
        if (this.transformer != null) {
            this.transformer.setFormattedOutput(shouldFormat);
        }
    }

    public void setFragment(boolean fragment) {
        this.fragment = fragment;
        if (this.transformer != null) {
            this.transformer.setFragment(fragment);
        }
    }

    public void setIncludeRoot(boolean includeRoot) {
        this.includeRoot = includeRoot;
    }

    public void setMarshalEmptyCollections(Boolean marshalEmptyCollections) {
        this.marshalEmptyCollections = marshalEmptyCollections;
    }

    public void setMediaType(MEDIA_TYPE mediaType) {
        this.mediaType = mediaType;
    }

    public void setNamespaceSeparator(char namespaceSeparator) {
        this.namespaceSeparator = namespaceSeparator;
    }

    public void setNoNamespaceSchemaLocation(String newNoNamespaceSchemaLocation) {
        this.noNamespaceSchemaLocation = newNoNamespaceSchemaLocation;
    }

    public void setReduceAnyArrays(boolean reduceAnyArrays) {
        this.reduceAnyArrays = reduceAnyArrays;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public void setSchemaLocation(String newSchemaLocation) {
        this.schemaLocation = newSchemaLocation;
    }

    public void setWrapperAsCollectionName(boolean wrapperAsCollectionName) {
        this.wrapperAsCollectionName = wrapperAsCollectionName;
    }

    public void setValueWrapper(String valueWrapper) {
        this.valueWrapper = valueWrapper;
    }

    public void setXmlHeader(String xmlHeader) {
        this.xmlHeader = xmlHeader;
    }

    public void setMarshalAttributeGroup(Object group) {
        this.marshalAttributeGroup = group;
    }

    public Object getMarshalAttributeGroup() {
        return this.marshalAttributeGroup;
    }
}

