/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import java.util.List;
import org.eclipse.linuxtools.docker.core.IDockerContainer;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.docker.core.IDockerImageHierarchyNode;
import org.eclipse.linuxtools.internal.docker.core.DockerImageHierarchyContainerNode;
import org.eclipse.linuxtools.internal.docker.core.DockerImageHierarchyImageNode;
import org.eclipse.linuxtools.internal.docker.core.DockerImageHierarchyNode;

public class DockerImageHierarchyNodeUtils {
    public static IDockerImageHierarchyNode resolveImageHierarchy(List<IDockerImage> images, List<IDockerContainer> containers, IDockerImage image) {
        IDockerImageHierarchyNode parentImageNode = DockerImageHierarchyNodeUtils.getImageParentImageNode(images, image.parentId());
        return DockerImageHierarchyNodeUtils.getDockerImageHierarchyNode(images, containers, image, parentImageNode);
    }

    public static IDockerImageHierarchyNode resolveImageHierarchy(List<IDockerImage> images, IDockerContainer container) {
        IDockerImageHierarchyNode parentImageNode = DockerImageHierarchyNodeUtils.getContainerParentImageNode(images, container.image());
        DockerImageHierarchyNode dockerImageHierarchyNode = DockerImageHierarchyNodeUtils.getDockerImageHierarchyNode(container, parentImageNode);
        return dockerImageHierarchyNode;
    }

    private static IDockerImageHierarchyNode getImageParentImageNode(List<IDockerImage> images, String parentImageId) {
        return images.stream().filter(image -> image.id().equals(parentImageId)).map(parentImage -> new DockerImageHierarchyImageNode((IDockerImage)parentImage, DockerImageHierarchyNodeUtils.getImageParentImageNode(images, parentImage.parentId()))).findFirst().orElse(null);
    }

    private static IDockerImageHierarchyNode getContainerParentImageNode(List<IDockerImage> images, String parentImageName) {
        return images.stream().filter(image -> image.repoTags().contains(parentImageName)).map(parentImage -> new DockerImageHierarchyImageNode((IDockerImage)parentImage, DockerImageHierarchyNodeUtils.getImageParentImageNode(images, parentImage.parentId()))).findFirst().orElse(null);
    }

    private static DockerImageHierarchyNode getDockerImageHierarchyNode(List<IDockerImage> images, List<IDockerContainer> containers, IDockerImage image, IDockerImageHierarchyNode parentImageNode) {
        DockerImageHierarchyImageNode imageNode = new DockerImageHierarchyImageNode(image, parentImageNode);
        DockerImageHierarchyNodeUtils.resolveChildrenImageNodes(images, containers, image.id(), image.repoTags(), imageNode);
        return imageNode;
    }

    private static void resolveChildrenImageNodes(List<IDockerImage> images, List<IDockerContainer> containers, String imageId, List<String> imageRepoTags, IDockerImageHierarchyNode parentNode) {
        images.stream().filter(image -> image.parentId() != null && image.parentId().equals(imageId)).forEach(image -> {
            DockerImageHierarchyImageNode childNode = new DockerImageHierarchyImageNode((IDockerImage)image, parentNode);
            DockerImageHierarchyNodeUtils.resolveChildrenImageNodes(images, containers, image.id(), image.repoTags(), childNode);
        });
        containers.stream().filter(container -> container.image() != null && imageRepoTags.contains(container.image())).forEach(container -> {
            DockerImageHierarchyContainerNode dockerImageHierarchyContainerNode = new DockerImageHierarchyContainerNode((IDockerContainer)container, parentNode);
        });
    }

    private static DockerImageHierarchyNode getDockerImageHierarchyNode(IDockerContainer container, IDockerImageHierarchyNode parentImageNode) {
        DockerImageHierarchyContainerNode containerNode = new DockerImageHierarchyContainerNode(container, parentImageNode);
        return containerNode;
    }
}

