/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.visualizer.ui.canvas;

import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class BufferedCanvas
extends Canvas
implements PaintListener,
ControlListener {
    protected Image m_doubleBuffer = null;
    protected GC m_doubleBufferGC = null;

    public BufferedCanvas(Composite parent) {
        super(parent, 0x140000);
        this.initBufferedCanvas();
    }

    public void dispose() {
        super.dispose();
        this.cleanupBufferedCanvas();
    }

    protected void initBufferedCanvas() {
        this.addControlListener(this);
        this.addPaintListener(this);
    }

    protected void cleanupBufferedCanvas() {
        if (!this.isDisposed()) {
            this.removePaintListener(this);
            this.removeControlListener(this);
        }
        if (this.m_doubleBuffer != null) {
            this.m_doubleBuffer.dispose();
            this.m_doubleBuffer = null;
        }
    }

    public void controlMoved(ControlEvent e) {
    }

    public void controlResized(ControlEvent e) {
        this.resized(this.getBounds());
    }

    public void resized(Rectangle bounds) {
    }

    protected synchronized GC getBufferedGC() {
        if (this.m_doubleBufferGC == null) {
            this.m_doubleBufferGC = new GC((Drawable)this.m_doubleBuffer);
        }
        return this.m_doubleBufferGC;
    }

    protected synchronized void disposeBufferedGC() {
        if (this.m_doubleBufferGC != null) {
            this.m_doubleBufferGC.dispose();
            this.m_doubleBufferGC = null;
        }
    }

    public void paintControl(PaintEvent e) {
        if (e.count <= 1) {
            Display display = e.display;
            GC gc = e.gc;
            this.paintDoubleBuffered(display, gc);
        }
    }

    protected void paintDoubleBuffered(Display display, GC gc) {
        Rectangle clientArea = this.getClientArea();
        int width = clientArea.width;
        int height = clientArea.height;
        if (this.m_doubleBuffer == null || this.m_doubleBuffer.getBounds().width < width || this.m_doubleBuffer.getBounds().height < height) {
            this.m_doubleBuffer = new Image((Device)display, width, height);
            this.disposeBufferedGC();
        }
        GC bgc = this.getBufferedGC();
        bgc.setBackground(gc.getBackground());
        bgc.setForeground(gc.getForeground());
        bgc.setFont(gc.getFont());
        bgc.setAlpha(255);
        try {
            this.paintCanvas(bgc);
        }
        catch (Throwable t) {
            System.err.println("BufferedCanvas: Exception thrown in painting code: \n" + t);
        }
        gc.drawImage(this.m_doubleBuffer, 0, 0);
    }

    public void paintCanvas(GC gc) {
        this.clearCanvas(gc);
    }

    public void clearCanvas(GC gc) {
        Rectangle bounds = this.getClientArea();
        gc.fillRectangle(bounds);
    }

    public void update() {
        if (!this.isDisposed()) {
            this.redraw();
        }
    }
}

