/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.model.association;

import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.wb.core.eval.ExecutionFlowDescription;
import org.eclipse.wb.core.eval.ExecutionFlowUtils;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.association.InvocationAssociation;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.variable.LazyVariableSupport;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.StatementTarget;
import org.eclipse.wb.internal.core.utils.check.Assert;

public final class InvocationVoidAssociation
extends InvocationAssociation {
    public InvocationVoidAssociation() {
    }

    public InvocationVoidAssociation(MethodInvocation invocation) {
        super(invocation);
    }

    public void setJavaInfo(JavaInfo javaInfo) throws Exception {
        super.setJavaInfo(javaInfo);
        CreationSupport creationSupport = this.m_javaInfo.getCreationSupport();
        this.m_invocation = (MethodInvocation)creationSupport.getNode();
    }

    public void move(StatementTarget target) throws Exception {
        if (this.m_javaInfo.getVariableSupport() instanceof LazyVariableSupport) {
            this.moveLazy(target);
        } else {
            super.move(target);
        }
    }

    private void moveLazy(StatementTarget target) throws Exception {
        LazyVariableSupport lazy = (LazyVariableSupport)this.m_javaInfo.getVariableSupport();
        ExecutionFlowDescription flow = JavaInfoUtils.getState(this.m_javaInfo).getFlowDescription();
        List<ASTNode> invocations = ExecutionFlowUtils.getInvocations(flow, lazy.m_accessor);
        Assert.isTrue2((!invocations.isEmpty() ? 1 : 0) != 0, (String)"No invocation for {0}", (Object[])new Object[]{lazy.m_accessor});
        ASTNode invocationInParent = invocations.get(0);
        Statement invocationStatement = AstNodeUtils.getEnclosingStatement(invocationInParent);
        this.m_editor.moveStatement(invocationStatement, target);
    }
}

