/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.patternlanguage.emf.ui.labeling;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.viatra.query.patternlanguage.emf.helper.PatternLanguageHelper;
import org.eclipse.viatra.query.patternlanguage.emf.vql.AggregatedValue;
import org.eclipse.viatra.query.patternlanguage.emf.vql.BoolValue;
import org.eclipse.viatra.query.patternlanguage.emf.vql.CallableRelation;
import org.eclipse.viatra.query.patternlanguage.emf.vql.CheckConstraint;
import org.eclipse.viatra.query.patternlanguage.emf.vql.ClassType;
import org.eclipse.viatra.query.patternlanguage.emf.vql.ClosureType;
import org.eclipse.viatra.query.patternlanguage.emf.vql.CompareConstraint;
import org.eclipse.viatra.query.patternlanguage.emf.vql.CompareFeature;
import org.eclipse.viatra.query.patternlanguage.emf.vql.EClassifierConstraint;
import org.eclipse.viatra.query.patternlanguage.emf.vql.EnumValue;
import org.eclipse.viatra.query.patternlanguage.emf.vql.FunctionEvaluationValue;
import org.eclipse.viatra.query.patternlanguage.emf.vql.ListValue;
import org.eclipse.viatra.query.patternlanguage.emf.vql.NumberValue;
import org.eclipse.viatra.query.patternlanguage.emf.vql.PackageImport;
import org.eclipse.viatra.query.patternlanguage.emf.vql.PathExpressionConstraint;
import org.eclipse.viatra.query.patternlanguage.emf.vql.Pattern;
import org.eclipse.viatra.query.patternlanguage.emf.vql.PatternBody;
import org.eclipse.viatra.query.patternlanguage.emf.vql.PatternCall;
import org.eclipse.viatra.query.patternlanguage.emf.vql.PatternCompositionConstraint;
import org.eclipse.viatra.query.patternlanguage.emf.vql.PatternModel;
import org.eclipse.viatra.query.patternlanguage.emf.vql.StringValue;
import org.eclipse.viatra.query.patternlanguage.emf.vql.Type;
import org.eclipse.viatra.query.patternlanguage.emf.vql.TypeCheckConstraint;
import org.eclipse.viatra.query.patternlanguage.emf.vql.ValueReference;
import org.eclipse.viatra.query.patternlanguage.emf.vql.VariableReference;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XNumberLiteral;
import org.eclipse.xtext.xbase.typesystem.computation.NumberLiterals;
import org.eclipse.xtext.xbase.ui.labeling.XbaseLabelProvider;

public class EMFPatternLanguageLabelProvider
extends XbaseLabelProvider {
    @Inject
    private NumberLiterals literals;

    @Inject
    public EMFPatternLanguageLabelProvider(AdapterFactoryLabelProvider delegate) {
        super(delegate);
    }

    protected Object doGetImage(Object element) {
        if (element instanceof PackageImport) {
            super.doGetImage((Object)((PackageImport)element).getEPackage());
        }
        return super.doGetImage(element);
    }

    String text(PatternModel model) {
        return "Pattern Model";
    }

    String text(PackageImport ele) {
        String name = ele.getEPackage() != null ? ele.getEPackage().getName() : "\u00abpackage\u00bb";
        return String.format("import %s", name);
    }

    String text(Pattern pattern) {
        return String.format("pattern %s/%d", pattern.getName(), pattern.getParameters().size());
    }

    String text(PatternBody ele) {
        return String.format("body #%d", ((Pattern)ele.eContainer()).getBodies().indexOf((Object)ele) + 1);
    }

    String text(EClassifierConstraint constraint) {
        String typename = ((ClassType)constraint.getType()).getClassname().getName();
        return String.format("%s (%s)", typename, constraint.getVar().getVar());
    }

    String text(CompareConstraint constraint) {
        CompareFeature feature = constraint.getFeature();
        String op = "<???>";
        if (feature == CompareFeature.EQUALITY) {
            op = "==";
        } else if (feature == CompareFeature.INEQUALITY) {
            op = "!=";
        }
        String left = this.getValueText(constraint.getLeftOperand());
        String right = this.getValueText(constraint.getRightOperand());
        return String.format("%s %s %s", left, op, right);
    }

    String text(PatternCompositionConstraint constraint) {
        String modifiers = constraint.isNegative() ? "neg " : "";
        return String.format("%s%s", modifiers, this.text(constraint.getCall()));
    }

    private String getTransitiveOperation(ClosureType type) {
        switch (type) {
            case REFLEXIVE_TRANSITIVE: {
                return "*";
            }
            case TRANSITIVE: {
                return "+";
            }
        }
        return "";
    }

    String text(CallableRelation relation) {
        if (relation instanceof PatternCall) {
            return this.text((PatternCall)relation);
        }
        if (relation instanceof EClassifierConstraint) {
            return this.text((EClassifierConstraint)relation);
        }
        if (relation instanceof TypeCheckConstraint) {
            return this.text((CallableRelation)((TypeCheckConstraint)relation));
        }
        if (relation instanceof PathExpressionConstraint) {
            return this.text((PathExpressionConstraint)relation);
        }
        return "Unknown callable";
    }

    String text(PatternCall call) {
        String transitiveOp = this.getTransitiveOperation(call.getTransitive());
        String name = call.getPatternRef() == null ? "<null>" : call.getPatternRef().getName();
        return String.format("find %s/%d%s", name, call.getParameters().size(), transitiveOp);
    }

    String text(PathExpressionConstraint constraint) {
        String typename = constraint.getSourceType().getClassname().getName();
        String fullTypeName = constraint.getEdgeTypes().stream().map(Type::getTypename).collect(Collectors.joining(".", String.valueOf(typename) + ".", ""));
        String varName = constraint.getSrc() != null ? constraint.getSrc().getVar() : "\u00abtype\u00bb";
        return String.format("%s (%s, %s)", fullTypeName, varName, this.getValueText(constraint.getDst()));
    }

    String text(CheckConstraint constraint) {
        return "check()";
    }

    String text(FunctionEvaluationValue eval) {
        return "eval()";
    }

    String text(AggregatedValue aggregate) {
        String aggregator = this.getAggregatorText(aggregate);
        String call = this.text(aggregate.getCall());
        return String.format("%s %s", aggregator, call);
    }

    private String getAggregatorText(AggregatedValue aggregator) {
        return aggregator.getAggregator().getSimpleName();
    }

    String getValueText(ValueReference ref) {
        if (ref instanceof VariableReference) {
            return ((VariableReference)ref).getVar();
        }
        if (ref instanceof NumberValue) {
            XNumberLiteral literal = ((NumberValue)ref).getValue();
            return this.literals.toJavaLiteral(literal);
        }
        if (ref instanceof BoolValue) {
            return Boolean.toString((Boolean)PatternLanguageHelper.getValue((ValueReference)ref, Boolean.class));
        }
        if (ref instanceof ListValue) {
            EList values = ((ListValue)ref).getValues();
            ArrayList<String> valueStrings = new ArrayList<String>();
            for (ValueReference valueReference : values) {
                valueStrings.add(this.getValueText(valueReference));
            }
            return "{" + Strings.concat((String)", ", valueStrings) + "}";
        }
        if (ref instanceof StringValue) {
            return "\"" + ((StringValue)ref).getValue() + "\"";
        }
        if (ref instanceof EnumValue) {
            EnumValue enumVal = (EnumValue)ref;
            if (enumVal.getLiteral() == null || enumVal.getLiteral().getLiteral() == null) {
                return "";
            }
            String enumName = enumVal.getEnumeration() != null ? enumVal.getEnumeration().getName() : enumVal.getLiteral().getEEnum().getName();
            return String.valueOf(enumName) + "::" + enumVal.getLiteral().getLiteral();
        }
        if (ref instanceof AggregatedValue) {
            return this.text((AggregatedValue)ref);
        }
        if (ref instanceof FunctionEvaluationValue) {
            return this.text((FunctionEvaluationValue)ref);
        }
        return null;
    }
}

