/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.datastore.core.historytree.classic;

import com.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.datastore.core.interval.IHTInterval;
import org.eclipse.tracecompass.internal.provisional.datastore.core.condition.TimeRangeCondition;
import org.eclipse.tracecompass.internal.provisional.datastore.core.exceptions.RangeException;
import org.eclipse.tracecompass.internal.provisional.datastore.core.historytree.HTNode;
import org.eclipse.tracecompass.internal.provisional.datastore.core.historytree.IHTNode;

public class ClassicNode<E extends IHTInterval>
extends HTNode<E> {
    public ClassicNode(IHTNode.NodeType type, int blockSize, int maxChildren, int seqNumber, int parentSeqNumber, long start) {
        super(type, blockSize, maxChildren, seqNumber, parentSeqNumber, start);
    }

    @Override
    protected @Nullable ClassicCoreNodeData createNodeExtraData(IHTNode.NodeType type) {
        if (type == IHTNode.NodeType.CORE) {
            return new ClassicCoreNodeData(this);
        }
        return null;
    }

    @Override
    protected @Nullable ClassicCoreNodeData getCoreNodeData() {
        return (ClassicCoreNodeData)super.getCoreNodeData();
    }

    @VisibleForTesting
    long getChildStart(int index) {
        ClassicCoreNodeData extraData = this.getCoreNodeData();
        if (extraData != null) {
            return extraData.getChildStart(index);
        }
        throw new UnsupportedOperationException("A leaf node does not have children");
    }

    protected static class ClassicCoreNodeData
    extends HTNode.CoreNodeData {
        private final long[] fChildStart;

        public ClassicCoreNodeData(ClassicNode<?> node) {
            super(node);
            int size = ((ClassicNode)node).getMaxChildren();
            this.fChildStart = new long[size];
        }

        protected ClassicNode<?> getNode() {
            return (ClassicNode)super.getNode();
        }

        @Override
        public void readSpecificHeader(@NonNull ByteBuffer buffer) {
            super.readSpecificHeader(buffer);
            int size = ((ClassicNode)this.getNode()).getMaxChildren();
            int i = 0;
            while (i < this.getNbChildren()) {
                this.fChildStart[i] = buffer.getLong();
                ++i;
            }
            i = this.getNbChildren();
            while (i < size) {
                buffer.getLong();
                ++i;
            }
        }

        @Override
        protected void writeSpecificHeader(@NonNull ByteBuffer buffer) {
            super.writeSpecificHeader(buffer);
            int size = ((ClassicNode)this.getNode()).getMaxChildren();
            int i = 0;
            while (i < this.getNbChildren()) {
                buffer.putLong(this.fChildStart[i]);
                ++i;
            }
            i = this.getNbChildren();
            while (i < size) {
                buffer.putLong(0L);
                ++i;
            }
        }

        @Override
        protected int getSpecificHeaderSize() {
            int maxChildren = ((ClassicNode)this.getNode()).getMaxChildren();
            int specificSize = super.getSpecificHeaderSize();
            return specificSize += 8 * maxChildren;
        }

        @Override
        public void linkNewChild(IHTNode<?> childNode) {
            ((ClassicNode)this.getNode()).takeWriteLock();
            try {
                super.linkNewChild(childNode);
                int nbChildren = this.getNbChildren();
                this.fChildStart[nbChildren - 1] = childNode.getNodeStart();
            }
            finally {
                ((ClassicNode)this.getNode()).releaseWriteLock();
            }
        }

        @Override
        protected Collection<Integer> selectNextIndices(TimeRangeCondition rc) {
            HTNode node = this.getNode();
            if (rc.min() < node.getNodeStart() || node.isOnDisk() && rc.max() > node.getNodeEnd()) {
                throw new RangeException("Requesting children outside the node's range: " + rc.toString());
            }
            ((ClassicNode)node).takeReadLock();
            try {
                long childEnd;
                long childStart;
                int nbChildren = this.getNbChildren();
                if (nbChildren == 0) {
                    List list = Collections.EMPTY_LIST;
                    return list;
                }
                long end = rc.max();
                LinkedList<Integer> matchingChildren = new LinkedList<Integer>();
                int i = 0;
                while (i < nbChildren - 1) {
                    childStart = this.fChildStart[i];
                    childEnd = this.fChildStart[i + 1] - 1L;
                    if (rc.intersects(childStart, childEnd)) {
                        matchingChildren.add(i);
                    }
                    if (end <= childEnd) {
                        LinkedList<Integer> linkedList = matchingChildren;
                        return linkedList;
                    }
                    ++i;
                }
                i = nbChildren - 1;
                childStart = this.fChildStart[i];
                childEnd = this.getNode().getNodeEnd();
                if (rc.intersects(childStart, childEnd)) {
                    matchingChildren.add(i);
                }
                LinkedList<Integer> linkedList = matchingChildren;
                return linkedList;
            }
            finally {
                ((ClassicNode)node).releaseReadLock();
            }
        }

        public long getChildStart(int index) {
            ((ClassicNode)this.getNode()).takeReadLock();
            try {
                if (index >= this.getNbChildren()) {
                    throw new IndexOutOfBoundsException("The child at index " + index + " does not exist");
                }
                long l = this.fChildStart[index];
                return l;
            }
            finally {
                ((ClassicNode)this.getNode()).releaseReadLock();
            }
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.fChildStart);
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            ClassicCoreNodeData other = (ClassicCoreNodeData)NonNullUtils.checkNotNull((Object)obj);
            return Arrays.equals(this.fChildStart, other.fChildStart);
        }
    }
}

