/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.java;

import org.eclipse.sapphire.modeling.annotations.Label;

@Label(standard="Java identifier")
public final class JavaIdentifier
implements Comparable<JavaIdentifier> {
    private final String text;

    public JavaIdentifier(String text) {
        if (text == null) {
            throw new IllegalArgumentException();
        }
        int length = text.length();
        if (length == 0) {
            throw new IllegalArgumentException();
        }
        char first = text.charAt(0);
        if (!Character.isJavaIdentifierStart(first)) {
            throw new IllegalArgumentException();
        }
        int i = 1;
        while (i < length) {
            if (!Character.isJavaIdentifierPart(text.charAt(i))) {
                throw new IllegalArgumentException();
            }
            ++i;
        }
        this.text = text;
    }

    public boolean equals(Object obj) {
        if (obj instanceof JavaIdentifier) {
            return this.text.equals(((JavaIdentifier)obj).text);
        }
        return false;
    }

    public int hashCode() {
        return this.text.hashCode();
    }

    @Override
    public int compareTo(JavaIdentifier obj) {
        return this.text.compareTo(obj.text);
    }

    public String toString() {
        return this.text;
    }
}

