/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.common.properties;

import org.eclipse.reddeer.common.exception.RedDeerException;
import org.eclipse.reddeer.common.logging.LoggingUtils;
import org.eclipse.reddeer.common.properties.RedDeerPropertyType;
import org.eclipse.reddeer.common.userprofile.UserProfile;

public enum RedDeerProperties {
    PAUSE_FAILED_TEST("rd.pauseFailedTest", false),
    LOG_MESSAGE_FILTER("rd.logMessageFilter", "ALL"),
    LOG_LEVEL("rd.logLevel", "ALL"),
    CLOSE_WELCOME_SCREEN("rd.closeWelcomeScreen", true),
    CLOSE_ALL_SHELLS("rd.closeShells", true),
    DISABLE_MAVEN_REPOSITORY_DOWNLOAD("rd.disableMavenIndex", true),
    LOG_COLLECTOR_ENABLED("rd.logCollectorEnabled", true),
    MAXIMIZE_WORKBENCH_ENABLED("rd.maximizeWorkbench", true),
    DEFAULT_KEY("rd.defaultKey", "org.eclipse.reddeer.widget.key"),
    CONFIG_FILE("rd.config", null),
    CAPTURE_SCREENSHOT("rd.captureScreenshot", true),
    RELATIVE_SCREENSHOT_DIRECTORY("rd.relativeScreenshotDirectory", null),
    OPEN_ASSOCIATED_PERSPECTIVE("rd.openAssociatedPerspective", "never"),
    TIME_PERIOD_FACTOR("rd.timePeriodFactor", Float.valueOf(1.0f));

    private String name;
    private RedDeerPropertyType type;
    private String defaultValue;
    private String[] supportedValues;

    private RedDeerProperties(String name, Boolean defaultValue) {
        this.name = name;
        this.type = RedDeerPropertyType.BOOLEAN;
        this.defaultValue = defaultValue.toString();
        this.supportedValues = new String[]{"true", "false"};
        this.checkSystemValue(this.getValueInternal());
    }

    private RedDeerProperties(String name, String defaultValue) {
        this.name = name;
        this.type = RedDeerPropertyType.TEXT;
        this.defaultValue = defaultValue;
        this.supportedValues = new String[0];
    }

    private RedDeerProperties(String name, String defaultValue, String ... supportedValues) {
        this.name = name;
        this.type = RedDeerPropertyType.ENUMERATION;
        this.defaultValue = defaultValue;
        this.supportedValues = supportedValues;
        this.checkSystemValue(this.getValueInternal());
    }

    private RedDeerProperties(String name, Float defaultValue) {
        this.name = name;
        this.type = RedDeerPropertyType.FLOAT;
        this.defaultValue = defaultValue.toString();
        this.supportedValues = new String[0];
        this.checkSystemValue(this.getValueInternal());
    }

    public static RedDeerProperties getByName(String name) {
        RedDeerProperties[] redDeerPropertiesArray = RedDeerProperties.values();
        int n = redDeerPropertiesArray.length;
        int n2 = 0;
        while (n2 < n) {
            RedDeerProperties property = redDeerPropertiesArray[n2];
            if (property.getName().equals(name)) {
                return property;
            }
            ++n2;
        }
        throw new RedDeerException("RedDeerProperties enumeration with name " + name + " does not exist");
    }

    public String getValue() {
        String value = this.getValueInternal();
        this.checkSystemValue(value);
        return value;
    }

    public boolean getBooleanValue() {
        if (this.getType() != RedDeerPropertyType.BOOLEAN) {
            throw new RedDeerException("Requested boolean system value from non boolean property [" + this.getName() + ", " + (Object)((Object)this.getType()) + "]");
        }
        String propertyValue = this.getValue();
        return Boolean.parseBoolean(propertyValue.toLowerCase());
    }

    public float getFloatValue() {
        if (this.getType() != RedDeerPropertyType.FLOAT) {
            throw new RedDeerException("Requested float system value from non float property [" + this.getName() + ", " + (Object)((Object)this.getType()) + "]");
        }
        String propertyValue = this.getValue();
        return Float.parseFloat(propertyValue.toLowerCase());
    }

    public String getName() {
        return this.name;
    }

    public RedDeerPropertyType getType() {
        return this.type;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String[] getSupportedValues() {
        return (String[])this.supportedValues.clone();
    }

    private void checkSystemValue(String systemValue) {
        if (this.getType() == RedDeerPropertyType.TEXT) {
            return;
        }
        if (this.getType() == RedDeerPropertyType.FLOAT) {
            try {
                Float.parseFloat(systemValue);
                return;
            }
            catch (Exception exception) {
                throw new RedDeerException("System property '" + this.getName() + "' has unsupported value '" + systemValue + "'. Value has to be floating point number");
            }
        }
        if (this.getType() == RedDeerPropertyType.BOOLEAN || this.getType() == RedDeerPropertyType.ENUMERATION) {
            systemValue = systemValue.toLowerCase();
        }
        String[] stringArray = this.getSupportedValues();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String supportedValue = stringArray[n2];
            if (systemValue == null || supportedValue.equals(systemValue)) {
                return;
            }
            ++n2;
        }
        throw new RedDeerException("System property '" + this.getName() + "' has unsupported value '" + systemValue + "'. Supported values are: " + LoggingUtils.format(this.getSupportedValues()));
    }

    private String getValueInternal() {
        String value = System.getProperty(this.getName());
        if (value == null && (value = UserProfile.getInstance().getProperty(this.getName())) == null) {
            value = this.getDefaultValue();
        }
        return value;
    }
}

