/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core.pdi.aif;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ptp.debug.core.pdi.model.aif.AIFFormatException;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeEnum;
import org.eclipse.ptp.internal.debug.core.pdi.aif.TypeIntegral;
import org.eclipse.ptp.internal.debug.core.pdi.messages.Messages;
import org.eclipse.ptp.internal.debug.core.pdi.model.aif.AIFFactory;

public class AIFTypeEnum
extends TypeIntegral
implements IAIFTypeEnum {
    private final List<String> fNames = new ArrayList<String>();
    private final List<Integer> fValues = new ArrayList<Integer>();
    private String fName = "";

    @Override
    public String[] getNames() {
        return this.fNames.toArray(new String[0]);
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public Integer[] getValues() {
        return this.fValues.toArray(new Integer[0]);
    }

    @Override
    public String toString() {
        String content = String.valueOf('<');
        content = String.valueOf(content) + this.getName() + '|';
        int i = 0;
        while (i < this.fNames.size()) {
            content = String.valueOf(content) + this.fNames.get(i) + '=' + this.fValues.get(i);
            if (i < this.fNames.size() - 1) {
                content = String.valueOf(content) + ',';
            }
            ++i;
        }
        return String.valueOf(content) + '>' + String.valueOf('i') + super.toString();
    }

    @Override
    public String parse(String fmt) throws AIFFormatException {
        fmt = this.parseName(fmt);
        while (fmt.length() > 0 && fmt.charAt(0) != '>') {
            if ((fmt = this.parseField(fmt)).charAt(0) != ',') continue;
            fmt = fmt.substring(1);
        }
        if (fmt.charAt(0) != '>') {
            throw new AIFFormatException(Messages.AIFTypeEnum_0);
        }
        fmt = fmt.substring(2);
        return super.parse(fmt);
    }

    private String parseField(String fmt) throws AIFFormatException {
        int pos = fmt.indexOf(61);
        if (pos == -1) {
            throw new AIFFormatException(Messages.AIFTypeEnum_1);
        }
        this.fNames.add(fmt.substring(0, pos));
        fmt = fmt.substring(pos + 1);
        pos = AIFFactory.getFirstNonDigitPos(fmt, 0, true);
        if (pos == -1) {
            throw new AIFFormatException(Messages.AIFTypeEnum_2);
        }
        this.fValues.add(Integer.parseInt(fmt.substring(0, pos)));
        return fmt.substring(pos);
    }

    protected String parseName(String fmt) throws AIFFormatException {
        int pos = fmt.indexOf(124);
        if (pos == -1) {
            throw new AIFFormatException(Messages.AIFTypeEnum_3);
        }
        this.fName = fmt.substring(0, pos);
        return fmt.substring(pos + 1);
    }
}

