/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.sort;

import java.util.Collection;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.persistence.IPersistable;
import org.eclipse.nebula.widgets.nattable.sort.ISortModel;
import org.eclipse.nebula.widgets.nattable.sort.SortDirectionEnum;
import org.eclipse.nebula.widgets.nattable.sort.SortStatePersistor;
import org.eclipse.nebula.widgets.nattable.sort.command.SortCommandHandler;
import org.eclipse.nebula.widgets.nattable.sort.config.DefaultSortConfiguration;

public class SortHeaderLayer<T>
extends AbstractLayerTransform
implements IPersistable {
    private final ISortModel sortModel;

    public SortHeaderLayer(ILayer underlyingLayer, ISortModel sortModel) {
        this(underlyingLayer, sortModel, true);
    }

    public SortHeaderLayer(ILayer underlyingLayer, ISortModel sortModel, boolean useDefaultConfiguration) {
        super(underlyingLayer);
        this.sortModel = sortModel;
        this.registerPersistable(new SortStatePersistor(sortModel));
        this.registerCommandHandler(new SortCommandHandler(sortModel, this));
        if (useDefaultConfiguration) {
            this.addConfiguration(new DefaultSortConfiguration());
        }
    }

    @Override
    public LabelStack getConfigLabelsByPosition(int columnPosition, int rowPosition) {
        int columnIndex;
        LabelStack configLabels = super.getConfigLabelsByPosition(columnPosition, rowPosition);
        if (this.sortModel != null && this.sortModel.isColumnIndexSorted(columnIndex = this.getColumnIndexByPosition(columnPosition))) {
            String sortConfig = "SORT_SEQ_" + this.sortModel.getSortOrder(columnIndex);
            configLabels.addLabelOnTop(sortConfig);
            SortDirectionEnum sortDirection = this.sortModel.getSortDirection(columnIndex);
            switch (sortDirection) {
                case ASC: {
                    configLabels.addLabelOnTop("SORT_UP");
                    break;
                }
                case DESC: {
                    configLabels.addLabelOnTop("SORT_DOWN");
                }
            }
            configLabels.addLabelOnTop("SORT");
        }
        return configLabels;
    }

    public ISortModel getSortModel() {
        return this.sortModel;
    }

    @Override
    public Collection<String> getProvidedLabels() {
        Collection<String> labels = super.getProvidedLabels();
        labels.add("SORT");
        labels.add("SORT_UP");
        labels.add("SORT_DOWN");
        labels.add("SORT_SEQ_0");
        labels.add("SORT_SEQ_1");
        labels.add("SORT_SEQ_2");
        return labels;
    }
}

