/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.snapshot.query;

import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.mat.internal.MATPlugin;
import org.eclipse.mat.snapshot.ISnapshot;
import org.osgi.framework.Bundle;

public final class Icons {
    private static final String PREFIX = "$nl$/META-INF/icons/";
    private static final String HEAPPREFIX = "$nl$/META-INF/icons/heapobjects/";
    public static final URL CLASS = Icons.build("class");
    public static final URL CLASS_IN = Icons.build("in/class");
    public static final URL CLASS_OUT = Icons.build("out/class");
    public static final URL CLASS_IN_OLD = Icons.build("in/class_in_old");
    public static final URL CLASS_OUT_OLD = Icons.build("out/class_out_old");
    public static final URL CLASS_IN_MIXED = Icons.build("in/class_mixed");
    public static final URL CLASS_OUT_MIXED = Icons.build("out/class_mixed");
    public static final URL OBJECT_INSTANCE = Icons.build("instance_obj");
    public static final URL CLASS_INSTANCE = Icons.build("class_obj");
    public static final URL ARRAY_INSTANCE = Icons.build("array_obj");
    public static final URL CLASSLOADER_INSTANCE = Icons.build("classloader_obj");
    public static final URL OBJECT_INSTANCE_AS_GC_ROOT = Icons.build("instance_obj_gc_root");
    public static final URL CLASS_INSTANCE_AS_GC_ROOT = Icons.build("class_obj_gc_root");
    public static final URL ARRAY_INSTANCE_AS_GC_ROOT = Icons.build("array_obj_gc_root");
    public static final URL CLASSLOADER_INSTANCE_AS_GC_ROOT = Icons.build("classloader_obj_gc_root");
    public static final URL PACKAGE = Icons.build("package");
    public static final URL SUPERCLASS = Icons.build("superclass");
    private static final URL OBJECT_INSTANCE_IN = Icons.build("in/instance_obj");
    private static final URL OBJECT_INSTANCE_IN_GC = Icons.build("in/instance_obj_gc_root");
    private static final URL OBJECT_INSTANCE_OUT = Icons.build("out/instance_obj");
    private static final URL OBJECT_INSTANCE_OUT_GC = Icons.build("out/instance_obj_gc_root");
    private static final URL CLASS_INSTANCE_IN = Icons.build("in/class_obj");
    private static final URL CLASS_INSTANCE_IN_GC = Icons.build("in/class_obj_gc_root");
    private static final URL CLASS_INSTANCE_OUT = Icons.build("out/class_obj");
    private static final URL CLASS_INSTANCE_OUT_GC = Icons.build("out/class_obj_gc_root");
    private static final URL ARRAY_INSTANCE_IN = Icons.build("in/array_obj");
    private static final URL ARRAY_INSTANCE_IN_GC = Icons.build("in/array_obj_gc_root");
    private static final URL ARRAY_INSTANCE_OUT = Icons.build("out/array_obj");
    private static final URL ARRAY_INSTANCE_OUT_GC = Icons.build("out/array_obj_gc_root");
    private static final URL CLASSLOADER_INSTANCE_IN = Icons.build("in/classloader_obj");
    private static final URL CLASSLOADER_INSTANCE_IN_GC = Icons.build("in/classloader_obj_gc_root");
    private static final URL CLASSLOADER_INSTANCE_OUT = Icons.build("out/classloader_obj");
    private static final URL CLASSLOADER_INSTANCE_OUT_GC = Icons.build("out/classloader_obj_gc_root");

    public static final URL forObject(ISnapshot snapshot, int objectId) {
        boolean isGCRoot = snapshot.isGCRoot(objectId);
        if (snapshot.isArray(objectId)) {
            return isGCRoot ? ARRAY_INSTANCE_AS_GC_ROOT : ARRAY_INSTANCE;
        }
        if (snapshot.isClass(objectId)) {
            return isGCRoot ? CLASS_INSTANCE_AS_GC_ROOT : CLASS_INSTANCE;
        }
        if (snapshot.isClassLoader(objectId)) {
            return isGCRoot ? CLASSLOADER_INSTANCE_AS_GC_ROOT : CLASSLOADER_INSTANCE;
        }
        return isGCRoot ? OBJECT_INSTANCE_AS_GC_ROOT : OBJECT_INSTANCE;
    }

    public static final URL inbound(ISnapshot snapshot, int objectId) {
        boolean isGCRoot = snapshot.isGCRoot(objectId);
        if (snapshot.isArray(objectId)) {
            return isGCRoot ? ARRAY_INSTANCE_IN_GC : ARRAY_INSTANCE_IN;
        }
        if (snapshot.isClass(objectId)) {
            return isGCRoot ? CLASS_INSTANCE_IN_GC : CLASS_INSTANCE_IN;
        }
        if (snapshot.isClassLoader(objectId)) {
            return isGCRoot ? CLASSLOADER_INSTANCE_IN_GC : CLASSLOADER_INSTANCE_IN;
        }
        return isGCRoot ? OBJECT_INSTANCE_IN_GC : OBJECT_INSTANCE_IN;
    }

    public static final URL outbound(ISnapshot snapshot, int objectId) {
        boolean isGCRoot = snapshot.isGCRoot(objectId);
        if (snapshot.isArray(objectId)) {
            return isGCRoot ? ARRAY_INSTANCE_OUT_GC : ARRAY_INSTANCE_OUT;
        }
        if (snapshot.isClass(objectId)) {
            return isGCRoot ? CLASS_INSTANCE_OUT_GC : CLASS_INSTANCE_OUT;
        }
        if (snapshot.isClassLoader(objectId)) {
            return isGCRoot ? CLASSLOADER_INSTANCE_OUT_GC : CLASSLOADER_INSTANCE_OUT;
        }
        return isGCRoot ? OBJECT_INSTANCE_OUT_GC : OBJECT_INSTANCE_OUT;
    }

    private static URL build(String name) {
        MATPlugin plugin = MATPlugin.getDefault();
        Path path = new Path(HEAPPREFIX + name + ".gif");
        URL url = FileLocator.find((Bundle)plugin.getBundle(), (IPath)path, null);
        return url;
    }

    public static URL getURL(String imageName) {
        MATPlugin plugin = MATPlugin.getDefault();
        Path path = new Path(PREFIX + imageName);
        URL url = FileLocator.find((Bundle)plugin.getBundle(), (IPath)path, null);
        return url;
    }
}

