/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.ui;

import java.awt.MouseInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.lsp4e.ContentTypeToLSPLaunchConfigEntry;
import org.eclipse.lsp4e.ContentTypeToLanguageServerDefinition;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.LoggingStreamConnectionProviderProxy;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class LoggingPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private TableViewer languageServerViewer;
    private TableViewer launchConfigurationViewer;
    private Map<String, Boolean> serverEnableLoggingToFile = new HashMap<String, Boolean>();
    private Map<String, Boolean> serverEnableLoggingToConsole = new HashMap<String, Boolean>();
    private IPreferenceStore store = LanguageServerPlugin.getDefault().getPreferenceStore();
    private boolean hasLoggingBeenChanged = false;

    public void init(IWorkbench workbench) {
    }

    public void dispose() {
        super.dispose();
    }

    protected Control createContents(Composite parent) {
        Composite res = new Composite(parent, 0);
        res.setLayout((Layout)new GridLayout(1, false));
        this.createStaticServersTable(res);
        this.createLaunchConfigurationServersTable(res);
        this.createLoggingContents(res);
        this.updateInputs();
        return res;
    }

    private void createStaticServersTable(Composite res) {
        this.languageServerViewer = new TableViewer(res);
        this.languageServerViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.languageServerViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        TableViewerColumn launchConfigColumn = new TableViewerColumn(this.languageServerViewer, 0);
        launchConfigColumn.getColumn().setText(Messages.PreferencesPage_languageServer);
        launchConfigColumn.getColumn().setWidth(300);
        launchConfigColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((LanguageServersRegistry.LanguageServerDefinition)((ContentTypeToLanguageServerDefinition)element).getValue()).label;
            }
        });
        this.addLoggingColumnsToViewer(this.languageServerViewer);
        this.languageServerViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.languageServerViewer.getTable().setHeaderVisible(true);
        this.languageServerViewer.getTable().setLinesVisible(true);
    }

    private void createLaunchConfigurationServersTable(Composite res) {
        this.launchConfigurationViewer = new TableViewer(res);
        this.launchConfigurationViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.launchConfigurationViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        TableViewerColumn launchConfigColumn = new TableViewerColumn(this.launchConfigurationViewer, 0);
        launchConfigColumn.getColumn().setText(Messages.PreferencesPage_LaunchConfiguration);
        launchConfigColumn.getColumn().setWidth(300);
        launchConfigColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ContentTypeToLSPLaunchConfigEntry)element).getLaunchConfiguration().getName();
            }
        });
        this.addLoggingColumnsToViewer(this.launchConfigurationViewer);
        this.launchConfigurationViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.launchConfigurationViewer.getTable().setHeaderVisible(true);
        this.languageServerViewer.getTable().setLinesVisible(true);
    }

    private void addLoggingColumnsToViewer(final TableViewer viewer) {
        final int addedColumnIndex = viewer.getTable().getColumnCount();
        TableViewerColumn logToFileColumn = new TableViewerColumn(viewer, 0);
        logToFileColumn.getColumn().setText(Messages.PreferencesPage_logging_toFile_title);
        logToFileColumn.getColumn().setWidth(100);
        logToFileColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return LoggingPreferencePage.this.serverEnableLoggingToFile.getOrDefault(((LanguageServersRegistry.LanguageServerDefinition)((ContentTypeToLanguageServerDefinition)element).getValue()).id, false) != false ? Messages.PreferencePage_enablementCondition_true : Messages.PreferencePage_enablementCondition_false;
            }
        });
        TableViewerColumn logToConsoleColumn = new TableViewerColumn(viewer, 0);
        logToConsoleColumn.getColumn().setText(Messages.PreferencesPage_logging_toConsole_title);
        logToConsoleColumn.getColumn().setWidth(125);
        logToConsoleColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return LoggingPreferencePage.this.serverEnableLoggingToConsole.getOrDefault(((LanguageServersRegistry.LanguageServerDefinition)((ContentTypeToLanguageServerDefinition)element).getValue()).id, false) != false ? Messages.PreferencePage_enablementCondition_true : Messages.PreferencePage_enablementCondition_false;
            }
        });
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                LoggingPreferencePage.this.hasLoggingBeenChanged = true;
                Point relativeCursorLocation = Display.getCurrent().getFocusControl().toControl(new Point(MouseInfo.getPointerInfo().getLocation().x, MouseInfo.getPointerInfo().getLocation().y));
                ViewerCell cell = ((TableViewer)event.getSource()).getCell(relativeCursorLocation);
                if (cell == null || cell.getColumnIndex() > addedColumnIndex + 1) {
                    return;
                }
                String key = ((LanguageServersRegistry.LanguageServerDefinition)((ContentTypeToLanguageServerDefinition)((StructuredSelection)event.getSelection()).getFirstElement()).getValue()).id;
                if (cell.getColumnIndex() == addedColumnIndex) {
                    boolean newLogging = LoggingPreferencePage.this.serverEnableLoggingToFile.getOrDefault(key, false) == false;
                    LoggingPreferencePage.this.serverEnableLoggingToFile.put(key, newLogging);
                } else {
                    boolean newLogging = LoggingPreferencePage.this.serverEnableLoggingToConsole.getOrDefault(key, false) == false;
                    LoggingPreferencePage.this.serverEnableLoggingToConsole.put(key, newLogging);
                }
                viewer.refresh();
            }
        });
    }

    private void createLoggingContents(Composite res) {
        Composite loggingComposite = new Composite(res, 0);
        loggingComposite.setLayout((Layout)new GridLayout(3, false));
        loggingComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Label infoLabel = new Label(loggingComposite, 0);
        infoLabel.setText(Messages.preferencesPage_logging_info);
        infoLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        Label fileLoggingLabel = new Label(loggingComposite, 0);
        fileLoggingLabel.setText(NLS.bind((String)Messages.PreferencesPage_logging_toFile_description, (Object)"languageServers-log"));
        Button disableFileLogging = new Button(loggingComposite, 0);
        disableFileLogging.setText(Messages.PreferencePage_enablementCondition_disableAll);
        disableFileLogging.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.serverEnableLoggingToFile.forEach((s, b) -> {
                Boolean bl = this.serverEnableLoggingToFile.put((String)s, false);
            });
            this.hasLoggingBeenChanged = true;
            this.languageServerViewer.refresh();
            this.launchConfigurationViewer.refresh();
        }));
        Button enableFileLogging = new Button(loggingComposite, 0);
        enableFileLogging.setText(Messages.PreferencePage_enablementCondition_enableAll);
        enableFileLogging.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.serverEnableLoggingToFile.forEach((s, b) -> {
                Boolean bl = this.serverEnableLoggingToFile.put((String)s, true);
            });
            this.hasLoggingBeenChanged = true;
            this.languageServerViewer.refresh();
            this.launchConfigurationViewer.refresh();
        }));
        Label consoleLoggingLabel = new Label(loggingComposite, 0);
        consoleLoggingLabel.setText(Messages.PreferencesPage_logging_toConsole_description);
        Button disableConsoleLogging = new Button(loggingComposite, 0);
        disableConsoleLogging.setText(Messages.PreferencePage_enablementCondition_disableAll);
        disableConsoleLogging.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.serverEnableLoggingToConsole.forEach((s, b) -> {
                Boolean bl = this.serverEnableLoggingToConsole.put((String)s, false);
            });
            this.hasLoggingBeenChanged = true;
            this.languageServerViewer.refresh();
            this.launchConfigurationViewer.refresh();
        }));
        Button enableConsoleLogging = new Button(loggingComposite, 0);
        enableConsoleLogging.setText(Messages.PreferencePage_enablementCondition_enableAll);
        enableConsoleLogging.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.serverEnableLoggingToConsole.forEach((s, b) -> {
                Boolean bl = this.serverEnableLoggingToConsole.put((String)s, true);
            });
            this.hasLoggingBeenChanged = true;
            this.languageServerViewer.refresh();
            this.launchConfigurationViewer.refresh();
        }));
    }

    protected void performDefaults() {
        this.serverEnableLoggingToFile.forEach((s, b) -> this.serverEnableLoggingToFile.put((String)s, this.store.getBoolean(LoggingStreamConnectionProviderProxy.lsToFileLoggingId(s))));
        this.serverEnableLoggingToConsole.forEach((s, b) -> this.serverEnableLoggingToConsole.put((String)s, this.store.getBoolean(LoggingStreamConnectionProviderProxy.lsToConsoleLoggingId(s))));
        this.launchConfigurationViewer.refresh();
        this.languageServerViewer.refresh();
        super.performDefaults();
    }

    private void applyLoggingEnablment() {
        this.serverEnableLoggingToFile.forEach((s, b) -> this.store.setValue(LoggingStreamConnectionProviderProxy.lsToFileLoggingId(s), b.booleanValue()));
        this.serverEnableLoggingToConsole.forEach((s, b) -> this.store.setValue(LoggingStreamConnectionProviderProxy.lsToConsoleLoggingId(s), b.booleanValue()));
        this.hasLoggingBeenChanged = false;
    }

    public boolean performOk() {
        if (this.hasLoggingBeenChanged) {
            this.applyLoggingEnablment();
            MessageDialog dialog = new MessageDialog(this.getShell(), Messages.PreferencesPage_restartWarning_title, null, Messages.PreferencesPage_restartWarning_message, 4, new String[]{IDialogConstants.NO_LABEL, Messages.PreferencesPage_restartWarning_restart}, 1);
            if (dialog.open() == 1) {
                PlatformUI.getWorkbench().restart();
            }
        }
        return super.performOk();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.updateInputs();
    }

    private void updateInputs() {
        HashSet languageServerIDs = new HashSet();
        ArrayList contentTypeToLSPLaunchConfigEntries = new ArrayList();
        LanguageServersRegistry.getInstance().getContentTypeToLSPLaunches().forEach(o -> {
            String id = ((LanguageServersRegistry.LanguageServerDefinition)o.getValue()).id;
            if (languageServerIDs.add(id)) {
                contentTypeToLSPLaunchConfigEntries.add(o);
                this.serverEnableLoggingToFile.put(id, this.serverEnableLoggingToFile.getOrDefault(id, this.store.getBoolean(LoggingStreamConnectionProviderProxy.lsToFileLoggingId(id))));
                this.serverEnableLoggingToConsole.put(id, this.serverEnableLoggingToConsole.getOrDefault(id, this.store.getBoolean(LoggingStreamConnectionProviderProxy.lsToConsoleLoggingId(id))));
            }
        });
        this.launchConfigurationViewer.setInput(contentTypeToLSPLaunchConfigEntries);
        this.launchConfigurationViewer.refresh();
        languageServerIDs.clear();
        ArrayList contentTypeToLanguageServerDefinitions = new ArrayList();
        LanguageServersRegistry.getInstance().getContentTypeToLSPExtensions().forEach(o -> {
            String id = ((LanguageServersRegistry.LanguageServerDefinition)o.getValue()).id;
            if (languageServerIDs.add(id)) {
                contentTypeToLanguageServerDefinitions.add(o);
                this.serverEnableLoggingToFile.put(id, this.serverEnableLoggingToFile.getOrDefault(id, this.store.getBoolean(LoggingStreamConnectionProviderProxy.lsToFileLoggingId(id))));
                this.serverEnableLoggingToConsole.put(id, this.serverEnableLoggingToConsole.getOrDefault(id, this.store.getBoolean(LoggingStreamConnectionProviderProxy.lsToConsoleLoggingId(id))));
            }
        });
        this.languageServerViewer.setInput(contentTypeToLanguageServerDefinitions);
        this.launchConfigurationViewer.refresh();
    }
}

