/*******************************************************************************
 * Copyright (c) 2016 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete.internal.impl.handler;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.client.AUTRegistry;
import org.eclipse.jubula.client.Result;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.annotations.Beta;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.StringUtils;

import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.constants.TestDataConstants;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * An ActionHandler directly executes the remote controlling commands for a
 * registered AUT - see {@link org.eclipse.jubula.client.AUTRegistry}
 *
 * Class representing the TreeTableComponentActionHandler component from the concrete toolkit.
 * @since 5.0
 */
@RealizedType(realizedType="guidancer.concrete.Tree")
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ActionHandlerGenerator", 
           date =  "2018-09-11T11:29:09.203Z")
public class TreeTableComponentActionHandler extends org.eclipse.jubula.toolkit.concrete.internal.impl.handler.TreeComponentActionHandler implements org.eclipse.jubula.toolkit.concrete.components.handler.TreeTableComponentActionHandler {
            public TreeTableComponentActionHandler(@NonNull ComponentIdentifier componentIdentifier) {
                super(componentIdentifier);
            }
    
    
        /**
         * 
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param exists 
         *        whether existence is expected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkExistenceOfAColumn(
            @Nullable String column,
            @Nullable Operator columnOperator,
            @Nullable Boolean exists,
            @Nullable Integer timeoutInMs
        )  {
            if (column == null) return null;
            
            if (columnOperator == null) return null;
            
            if (exists == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcCheckExistenceOfColumn")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(column)
                            .addParameter(columnOperator.rcValue())
                            .addParameter(exists)
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param exists 
         *        whether existence is expected or not
         * @since 4.1
         */
        public Result checkExistenceOfAColumn(
            @Nullable String column,
            @Nullable Operator columnOperator,
            @Nullable Boolean exists
        )  {
            if (column == null) return null;
            
            if (columnOperator == null) return null;
            
            if (exists == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcCheckExistenceOfColumn")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(column)
                            .addParameter(columnOperator.rcValue())
                            .addParameter(exists)
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param numberOfClicks 
         *        the amount of interactions
         * @param column 
         *        the column
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * 
         */
        public Result selectEntryByTextpathSpecifyColumn(
            @Nullable SearchType pathType,
            @Nullable Integer preAscend,
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Integer numberOfClicks,
            @Nullable Integer column,
            @Nullable InteractionMode mouseButton
        )  {
            if (pathType == null) return null;
            
            if (preAscend == null) return null;
            
            if (textpath == null) return null;
            
            if (operator == null) return null;
            
            if (numberOfClicks == null) return null;
            
            if (column == null) return null;
            
            if (mouseButton == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcSelect")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(pathType.rcValue())
                            .addParameter(preAscend)
                            .addParameter(textpath)
                            .addParameter(operator.rcValue())
                            .addParameter(numberOfClicks)
                            .addParameter(column)
                            .addParameter(mouseButton.rcIntValue())
                            .build(), null);
        }
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param numberOfClicks 
         *        the amount of interactions
         * @param column 
         *        the column
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * 
         */
        public Result selectEntryByIndexpathSpecifyColumn(
            @Nullable SearchType pathType,
            @Nullable Integer preAscend,
            @Nullable String indexpath,
            @Nullable Integer numberOfClicks,
            @Nullable Integer column,
            @Nullable InteractionMode mouseButton
        )  {
            if (pathType == null) return null;
            
            if (preAscend == null) return null;
            
            if (indexpath == null) return null;
            
            if (numberOfClicks == null) return null;
            
            if (column == null) return null;
            
            if (mouseButton == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcSelectByIndices")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(pathType.rcValue())
                            .addParameter(preAscend)
                            .addParameter(indexpath)
                            .addParameter(numberOfClicks)
                            .addParameter(column)
                            .addParameter(mouseButton.rcIntValue())
                            .build(), null);
        }
        
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param column 
         *        the column
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * 
         */
        public Result checkSelectionByValueSSpecifyColumn(
            @Nullable String text,
            @Nullable Operator operator,
            @Nullable Integer column,
            @Nullable Integer timeoutInMs
        )  {
            if (text == null) return null;
            
            if (operator == null) return null;
            
            if (column == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifySelectedValue")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(text)
                            .addParameter(operator.rcValue())
                            .addParameter(column)
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param column 
         *        the column
         * 
         */
        public Result checkSelectionByValueSSpecifyColumn(
            @Nullable String text,
            @Nullable Operator operator,
            @Nullable Integer column
        )  {
            if (text == null) return null;
            
            if (operator == null) return null;
            
            if (column == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifySelectedValue")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(text)
                            .addParameter(operator.rcValue())
                            .addParameter(column)
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param numberOfClicks 
         *        the amount of interactions
         * @param column 
         *        the column
         * @param columnOperator 
         *        the operator used for comparison
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @since 4.1
         */
        public Result selectEntryByTextpathSpecifyColumnPath(
            @Nullable SearchType pathType,
            @Nullable Integer preAscend,
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Integer numberOfClicks,
            @Nullable String column,
            @Nullable Operator columnOperator,
            @Nullable InteractionMode mouseButton
        )  {
            if (pathType == null) return null;
            
            if (preAscend == null) return null;
            
            if (textpath == null) return null;
            
            if (operator == null) return null;
            
            if (numberOfClicks == null) return null;
            
            if (column == null) return null;
            
            if (columnOperator == null) return null;
            
            if (mouseButton == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcSelectColumnPath")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(pathType.rcValue())
                            .addParameter(preAscend)
                            .addParameter(textpath)
                            .addParameter(operator.rcValue())
                            .addParameter(numberOfClicks)
                            .addParameter(column)
                            .addParameter(columnOperator.rcValue())
                            .addParameter(mouseButton.rcIntValue())
                            .build(), null);
        }
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param numberOfClicks 
         *        the amount of interactions
         * @param column 
         *        the column
         * @param operator 
         *        the operator used for comparison
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @since 4.1
         */
        public Result selectEntryByIndexpathSpecifyColumnPath(
            @Nullable SearchType pathType,
            @Nullable Integer preAscend,
            @Nullable String indexpath,
            @Nullable Integer numberOfClicks,
            @Nullable String column,
            @Nullable Operator operator,
            @Nullable InteractionMode mouseButton
        )  {
            if (pathType == null) return null;
            
            if (preAscend == null) return null;
            
            if (indexpath == null) return null;
            
            if (numberOfClicks == null) return null;
            
            if (column == null) return null;
            
            if (operator == null) return null;
            
            if (mouseButton == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcSelectByColumnPath")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(pathType.rcValue())
                            .addParameter(preAscend)
                            .addParameter(indexpath)
                            .addParameter(numberOfClicks)
                            .addParameter(column)
                            .addParameter(operator.rcValue())
                            .addParameter(mouseButton.rcIntValue())
                            .build(), null);
        }
        
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param column 
         *        the column
         * @param columnOperator 
         *        the operator used for comparison
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkSelectionByValueSSpecifyColumnPath(
            @Nullable String text,
            @Nullable Operator operator,
            @Nullable String column,
            @Nullable Operator columnOperator,
            @Nullable Integer timeoutInMs
        )  {
            if (text == null) return null;
            
            if (operator == null) return null;
            
            if (column == null) return null;
            
            if (columnOperator == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifySelectedValueAtPath")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(text)
                            .addParameter(operator.rcValue())
                            .addParameter(column)
                            .addParameter(columnOperator.rcValue())
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param column 
         *        the column
         * @param columnOperator 
         *        the operator used for comparison
         * @since 4.1
         */
        public Result checkSelectionByValueSSpecifyColumnPath(
            @Nullable String text,
            @Nullable Operator operator,
            @Nullable String column,
            @Nullable Operator columnOperator
        )  {
            if (text == null) return null;
            
            if (operator == null) return null;
            
            if (column == null) return null;
            
            if (columnOperator == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifySelectedValueAtPath")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(text)
                            .addParameter(operator.rcValue())
                            .addParameter(column)
                            .addParameter(columnOperator.rcValue())
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * Use this action to check the text in a cell based on the current position of the cursor
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkTextOfCellMousePosition(
            @Nullable String text,
            @Nullable Operator operator,
            @Nullable Integer timeoutInMs
        )  {
            if (text == null) return null;
            
            if (operator == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyCellTextAtMousePosition")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(text)
                            .addParameter(operator.rcValue())
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * Use this action to check the text in a cell based on the current position of the cursor
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @since 4.1
         */
        public Result checkTextOfCellMousePosition(
            @Nullable String text,
            @Nullable Operator operator
        )  {
            if (text == null) return null;
            
            if (operator == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyCellTextAtMousePosition")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(text)
                            .addParameter(operator.rcValue())
                            .addParameter(0)
                            .build(), null);
        }
        
        
        /**
         * Use this action to read the value in the cell where the mouse is currently placed so that you can use the value in the cell as data for other Test Steps
         * @since 4.1
         */
        public Result getValueAtMousePosition(
        )  {
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcReadValueAtMousePosition")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .build(), null);
        }
        
        /**
         * 
         * @param editable 
         *        whether the component is expected to be editable or not
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkEditabilitySpecifyCell(
            @Nullable Boolean editable,
            @Nullable String row,
            @Nullable Operator rowOperator,
            @Nullable String column,
            @Nullable Operator columnOperator,
            @Nullable Integer timeoutInMs
        )  {
            if (editable == null) return null;
            
            if (row == null) return null;
            
            if (rowOperator == null) return null;
            
            if (column == null) return null;
            
            if (columnOperator == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyEditable")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(editable)
                            .addParameter(row)
                            .addParameter(rowOperator.rcValue())
                            .addParameter(column)
                            .addParameter(columnOperator.rcValue())
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param editable 
         *        whether the component is expected to be editable or not
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @since 4.1
         */
        public Result checkEditabilitySpecifyCell(
            @Nullable Boolean editable,
            @Nullable String row,
            @Nullable Operator rowOperator,
            @Nullable String column,
            @Nullable Operator columnOperator
        )  {
            if (editable == null) return null;
            
            if (row == null) return null;
            
            if (rowOperator == null) return null;
            
            if (column == null) return null;
            
            if (columnOperator == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyEditable")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(editable)
                            .addParameter(row)
                            .addParameter(rowOperator.rcValue())
                            .addParameter(column)
                            .addParameter(columnOperator.rcValue())
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * Use this action to check whether a cell at the current mouse position is editable or not
         * @param editable 
         *        whether the component is expected to be editable or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkEditabilityOfCellMousePosition(
            @Nullable Boolean editable,
            @Nullable Integer timeoutInMs
        )  {
            if (editable == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyEditableMousePosition")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(editable)
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * Use this action to check whether a cell at the current mouse position is editable or not
         * @param editable 
         *        whether the component is expected to be editable or not
         * @since 4.1
         */
        public Result checkEditabilityOfCellMousePosition(
            @Nullable Boolean editable
        )  {
            if (editable == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyEditableMousePosition")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(editable)
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * Use this action to check whether the currently selected cell is editable or not
         * @param editable 
         *        whether the component is expected to be editable or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkEditabilityOfSelectedCell(
            @Nullable Boolean editable,
            @Nullable Integer timeoutInMs
        )  {
            if (editable == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifySelectedEditable")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(editable)
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * Use this action to check whether the currently selected cell is editable or not
         * @param editable 
         *        whether the component is expected to be editable or not
         * @since 4.1
         */
        public Result checkEditabilityOfSelectedCell(
            @Nullable Boolean editable
        )  {
            if (editable == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifySelectedEditable")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(editable)
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * 
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param searchType 
         *        the search type
         * @param exists 
         *        whether existence is expected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkExistenceOfValueInRow(
            @Nullable String row,
            @Nullable Operator rowOperator,
            @Nullable String value,
            @Nullable Operator valueOperator,
            @Nullable SearchType searchType,
            @Nullable Boolean exists,
            @Nullable Integer timeoutInMs
        )  {
            if (row == null) return null;
            
            if (rowOperator == null) return null;
            
            if (value == null) return null;
            
            if (valueOperator == null) return null;
            
            if (searchType == null) return null;
            
            if (exists == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyValueInRow")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(row)
                            .addParameter(rowOperator.rcValue())
                            .addParameter(value)
                            .addParameter(valueOperator.rcValue())
                            .addParameter(searchType.rcValue())
                            .addParameter(exists)
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param searchType 
         *        the search type
         * @param exists 
         *        whether existence is expected or not
         * @since 4.1
         */
        public Result checkExistenceOfValueInRow(
            @Nullable String row,
            @Nullable Operator rowOperator,
            @Nullable String value,
            @Nullable Operator valueOperator,
            @Nullable SearchType searchType,
            @Nullable Boolean exists
        )  {
            if (row == null) return null;
            
            if (rowOperator == null) return null;
            
            if (value == null) return null;
            
            if (valueOperator == null) return null;
            
            if (searchType == null) return null;
            
            if (exists == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyValueInRow")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(row)
                            .addParameter(rowOperator.rcValue())
                            .addParameter(value)
                            .addParameter(valueOperator.rcValue())
                            .addParameter(searchType.rcValue())
                            .addParameter(exists)
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * 
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param searchType 
         *        the search type
         * @param exists 
         *        whether existence is expected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkExistenceOfValueInColumn(
            @Nullable String column,
            @Nullable Operator columnOperator,
            @Nullable String value,
            @Nullable Operator valueOperator,
            @Nullable SearchType searchType,
            @Nullable Boolean exists,
            @Nullable Integer timeoutInMs
        )  {
            if (column == null) return null;
            
            if (columnOperator == null) return null;
            
            if (value == null) return null;
            
            if (valueOperator == null) return null;
            
            if (searchType == null) return null;
            
            if (exists == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyValueInColumn")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(column)
                            .addParameter(columnOperator.rcValue())
                            .addParameter(value)
                            .addParameter(valueOperator.rcValue())
                            .addParameter(searchType.rcValue())
                            .addParameter(exists)
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param searchType 
         *        the search type
         * @param exists 
         *        whether existence is expected or not
         * @since 4.1
         */
        public Result checkExistenceOfValueInColumn(
            @Nullable String column,
            @Nullable Operator columnOperator,
            @Nullable String value,
            @Nullable Operator valueOperator,
            @Nullable SearchType searchType,
            @Nullable Boolean exists
        )  {
            if (column == null) return null;
            
            if (columnOperator == null) return null;
            
            if (value == null) return null;
            
            if (valueOperator == null) return null;
            
            if (searchType == null) return null;
            
            if (exists == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyValueInColumn")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(column)
                            .addParameter(columnOperator.rcValue())
                            .addParameter(value)
                            .addParameter(valueOperator.rcValue())
                            .addParameter(searchType.rcValue())
                            .addParameter(exists)
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * 
         * @param text 
         *        the text to use
         * @param textOperator 
         *        the text operator
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkTextSpecifyCell(
            @Nullable String text,
            @Nullable Operator textOperator,
            @Nullable String row,
            @Nullable Operator rowOperator,
            @Nullable String column,
            @Nullable Operator columnOperator,
            @Nullable Integer timeoutInMs
        )  {
            if (text == null) return null;
            
            if (textOperator == null) return null;
            
            if (row == null) return null;
            
            if (rowOperator == null) return null;
            
            if (column == null) return null;
            
            if (columnOperator == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyText")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(text)
                            .addParameter(textOperator.rcValue())
                            .addParameter(row)
                            .addParameter(rowOperator.rcValue())
                            .addParameter(column)
                            .addParameter(columnOperator.rcValue())
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param text 
         *        the text to use
         * @param textOperator 
         *        the text operator
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @since 4.1
         */
        public Result checkTextSpecifyCell(
            @Nullable String text,
            @Nullable Operator textOperator,
            @Nullable String row,
            @Nullable Operator rowOperator,
            @Nullable String column,
            @Nullable Operator columnOperator
        )  {
            if (text == null) return null;
            
            if (textOperator == null) return null;
            
            if (row == null) return null;
            
            if (rowOperator == null) return null;
            
            if (column == null) return null;
            
            if (columnOperator == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyText")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(text)
                            .addParameter(textOperator.rcValue())
                            .addParameter(row)
                            .addParameter(rowOperator.rcValue())
                            .addParameter(column)
                            .addParameter(columnOperator.rcValue())
                            .addParameter(0)
                            .build(), null);
        }
        
        
        /**
         * Use this action to read the value of the specified cell so that you can use the value in the cell as data for other Test Steps
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @since 4.1
         */
        public Result getValueSpecifyCell(
            @Nullable String row,
            @Nullable Operator rowOperator,
            @Nullable String column,
            @Nullable Operator columnOperator
        )  {
            if (row == null) return null;
            
            if (rowOperator == null) return null;
            
            if (column == null) return null;
            
            if (columnOperator == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcReadValue")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(row)
                            .addParameter(rowOperator.rcValue())
                            .addParameter(column)
                            .addParameter(columnOperator.rcValue())
                            .build(), null);
        }
        
        /**
         * 
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param numberOfClicks 
         *        the amount of interactions
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param extendSelection 
         *        whether to extend the selection or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @since 4.1
         */
        public Result selectCell(
            @Nullable String row,
            @Nullable Operator rowOperator,
            @Nullable String column,
            @Nullable Operator columnOperator,
            @Nullable Integer numberOfClicks,
            @Nullable Integer xPosition,
            @Nullable Unit xUnits,
            @Nullable Integer yPosition,
            @Nullable Unit yUnits,
            @Nullable BinaryChoice extendSelection,
            @Nullable InteractionMode mouseButton
        )  {
            if (row == null) return null;
            
            if (rowOperator == null) return null;
            
            if (column == null) return null;
            
            if (columnOperator == null) return null;
            
            if (numberOfClicks == null) return null;
            
            if (xPosition == null) return null;
            
            if (xUnits == null) return null;
            
            if (yPosition == null) return null;
            
            if (yUnits == null) return null;
            
            if (extendSelection == null) return null;
            
            if (mouseButton == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcSelectCell")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(row)
                            .addParameter(rowOperator.rcValue())
                            .addParameter(column)
                            .addParameter(columnOperator.rcValue())
                            .addParameter(numberOfClicks)
                            .addParameter(xPosition)
                            .addParameter(xUnits.rcValue())
                            .addParameter(yPosition)
                            .addParameter(yUnits.rcValue())
                            .addParameter(extendSelection.rcValue())
                            .addParameter(mouseButton.rcIntValue())
                            .build(), null);
        }
        
        /**
         * 
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param numberOfClicks 
         *        the amount of interactions
         * @param extendSelection 
         *        whether to extend the selection or not
         * @param searchType 
         *        the search type
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @since 4.1
         */
        public Result selectValueFromColumn(
            @Nullable String column,
            @Nullable Operator columnOperator,
            @Nullable String value,
            @Nullable Operator valueOperator,
            @Nullable Integer numberOfClicks,
            @Nullable BinaryChoice extendSelection,
            @Nullable SearchType searchType,
            @Nullable InteractionMode mouseButton
        )  {
            if (column == null) return null;
            
            if (columnOperator == null) return null;
            
            if (value == null) return null;
            
            if (valueOperator == null) return null;
            
            if (numberOfClicks == null) return null;
            
            if (extendSelection == null) return null;
            
            if (searchType == null) return null;
            
            if (mouseButton == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcSelectRowByValue")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(column)
                            .addParameter(columnOperator.rcValue())
                            .addParameter(value)
                            .addParameter(valueOperator.rcValue())
                            .addParameter(numberOfClicks)
                            .addParameter(extendSelection.rcValue())
                            .addParameter(searchType.rcValue())
                            .addParameter(mouseButton.rcIntValue())
                            .build(), null);
        }
        
        /**
         * 
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param numberOfClicks 
         *        the amount of interactions
         * @param extendSelection 
         *        whether to extend the selection or not
         * @param searchType 
         *        the search type
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @since 4.1
         */
        public Result selectValueFromRow(
            @Nullable String row,
            @Nullable Operator rowOperator,
            @Nullable String value,
            @Nullable Operator valueOperator,
            @Nullable Integer numberOfClicks,
            @Nullable BinaryChoice extendSelection,
            @Nullable SearchType searchType,
            @Nullable InteractionMode mouseButton
        )  {
            if (row == null) return null;
            
            if (rowOperator == null) return null;
            
            if (value == null) return null;
            
            if (valueOperator == null) return null;
            
            if (numberOfClicks == null) return null;
            
            if (extendSelection == null) return null;
            
            if (searchType == null) return null;
            
            if (mouseButton == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcSelectCellByColValue")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(row)
                            .addParameter(rowOperator.rcValue())
                            .addParameter(value)
                            .addParameter(valueOperator.rcValue())
                            .addParameter(numberOfClicks)
                            .addParameter(extendSelection.rcValue())
                            .addParameter(searchType.rcValue())
                            .addParameter(mouseButton.rcIntValue())
                            .build(), null);
        }
        
} 