/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.dialogs;

import org.apache.commons.lang.StringUtils;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jubula.client.ui.dialogs.AbstractValidatedDialog;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.LayoutUtil;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class EnterCommentDialog
extends AbstractValidatedDialog {
    private IValidator m_validator;
    private WritableValue m_commentTitle;
    private String m_initialTitle = null;

    public EnterCommentDialog(Shell parentShell, IValidator commentValidator, String title) {
        super(parentShell);
        this.setValidator(commentValidator);
        this.m_initialTitle = title;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.EnterCommentDialogTitle);
        this.setMessage(Messages.EnterCommentDialogMessage);
        this.getShell().setText(Messages.EnterCommentDialogTitle);
        GridData gridData = new GridData(4, 4, true, true);
        Composite area = new Composite(parent, 2048);
        area.setLayoutData((Object)gridData);
        area.setLayout((Layout)new GridLayout(2, false));
        this.createCommentTitleField(area);
        this.createDialogAdditionalArea(area);
        return area;
    }

    protected void createDialogAdditionalArea(Composite area) {
    }

    protected Point getInitialSize() {
        Point shellSize = super.getInitialSize();
        return new Point(Math.max(this.convertHorizontalDLUsToPixels(450), shellSize.x), Math.max(this.convertVerticalDLUsToPixels(100), shellSize.y));
    }

    protected boolean isResizable() {
        return true;
    }

    private void createCommentTitleField(Composite area) {
        Text commentTitleField = this.createCommentTitleText(area);
        GridData gridData = new GridData(4, 4, true, false);
        LayoutUtil.addToolTipAndMaxWidth(gridData, (Control)commentTitleField);
        commentTitleField.setLayoutData((Object)gridData);
        ISWTObservableValue commentTitleFieldText = WidgetProperties.text((int)24).observe((Widget)commentTitleField);
        this.m_commentTitle = WritableValue.withValueType(String.class);
        this.getValidationContext().bindValue((IObservableValue)commentTitleFieldText, (IObservableValue)this.m_commentTitle, new UpdateValueStrategy().setAfterGetValidator(this.getValidator()), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE));
        if (!StringUtils.isEmpty((String)this.m_initialTitle)) {
            this.m_commentTitle.setValue((Object)this.m_initialTitle);
        }
        LayoutUtil.setMaxChar(commentTitleField, 4000);
        commentTitleField.selectAll();
    }

    private Text createCommentTitleText(Composite area) {
        new Label(area, 0).setText(Messages.EnterCommentDialogTitleLabel);
        return new Text(area, 2052);
    }

    public String getCommentTitle() {
        return (String)this.m_commentTitle.getValue();
    }

    protected IValidator getValidator() {
        return this.m_validator;
    }

    private void setValidator(IValidator validator) {
        this.m_validator = validator;
    }
}

